<?php
function generate_menu_based_sitemap() {
    $selected_menu = get_option('sitemap_menu');
    if (!$selected_menu) {
        return 'No menu selected for the sitemap.';
    }

    $menu_items = wp_get_nav_menu_items($selected_menu);
    if (!$menu_items) {
        return 'No items in the selected menu.';
    }

    $menu_tree = build_menu_tree($menu_items);
    $output = render_menu_tree($menu_tree);

    return $output;
}
add_shortcode('menu_sitemap', 'generate_menu_based_sitemap');

function build_menu_tree($items, $parent_id = 0) {
    $branch = array();
    foreach ($items as $item) {
        if ($item->menu_item_parent == $parent_id) {
            $children = build_menu_tree($items, $item->ID);
            if ($children) {
                $item->children = $children;
            }
            $branch[] = $item;
        }
    }

    return $branch;
}

function render_menu_tree($tree) {
    $output = '<ul>';
    foreach ($tree as $item) {
        $output .= '<li><a href="' . $item->url . '">' . $item->title . '</a>';
        if (!empty($item->children)) {
            $output .= render_menu_tree($item->children);
        }
        $output .= '</li>';
    }
    $output .= '</ul>';

    return $output;
}
