<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/ace/1.31.2/ace.js" integrity="sha512-mkot3HRJhKBg0jgaOGO10Ve1Y1V1YRiFx4l2itBAZUjXYfDKgxbPUhSjp3UFq8oQmHDL1yAXG3nMFRMhPgFlrA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<p class="mb-5 text-xl font-semibold leading-none text-gray-">
    Pixels de suivi 
</p>
<p class="mb-1 text-base font-semibold leading-none text-gray-">
    <a about="_blank" href="https://support.google.com/analytics/answer/12131703" class="">Code d'intégration Google Analytics</a>
</p>
<p class="mb-3 text-sm font-normal">
    Copiez-collez le code d'intégration fourni par Google Analytics/Ads
</p>
<form title="Paramètre des Pixels sauvegardé" method="post" action="options.php">   
<?php settings_fields('pixels-settings'); ?>

<div id='analytics' style="height: 300px">
</div>
<textarea hidden name="google_analytics">
<?= get_option('google_analytics') ?>
</textarea>
<div class="flex items-center mb-4 mt-4">
<label for="checkbox-analytics" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-900">
      <input id="checkbox-analytics" type="checkbox" value="1" name="explicit_google" <?php checked(1, get_option('explicit_google'), true); ?> class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:focus:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" >
      L'utilisateur doit explicitement autoriser le suivi Google Analytics</label>
</div>
<div class="flex items-center mb-4 mt-4">
<label for="checkbox-ads" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-900">
      <input id="checkbox-ads" type="checkbox" value="1" name="google_ads_enabled" <?php checked(1, get_option('google_ads_enabled'), true); ?> class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:focus:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" >
      L'utilisateur doit explicitement autoriser le suivi Google Ads</label>
</div>

<button type="submit" class="mb-6 text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Sauvegarder le code d'intégration</button>

<p class="mb-1 text-base font-semibold leading-none text-gray-">
    <a about="_blank" href="https://support.google.com/analytics/answer/12131703" class="">Code d'intégration Facebooks Ads</a>
</p>


<p class="mb-3 text-sm font-normal">
    Copiez-collez le code d'intégration fourni par Facebook
</p>

<div id='social-ads' style="height: 300px">

</div>
<textarea hidden name="facebook_pixel">
<?= get_option('facebook_pixel') ?>
</textarea>
<div class="flex items-center mb-4 mt-4">
<label for="checkbox-social-ads" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-900">
      <input id="checkbox-social-ads" type="checkbox" value="1" name="explicit_facebook" <?php checked(1, get_option('explicit_facebook'), true); ?> class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:focus:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600" >
      L'utilisateur doit explicitement autoriser le suivi Facebook Ads</label>
</div>
<button type="submit" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Sauvegarder le code d'intégration</button>
</form>

<script>
// Easiest way to run ACE editor in container with id="example"

var googleAnalytics = document.querySelector("[name='google_analytics']");
var facebookPixel = document.querySelector("[name='facebook_pixel']");
var analytics = ace.edit("analytics", {
    theme: "ace/theme/textmate",
    mode: "ace/mode/html",
    value: googleAnalytics.value,
});
var social = ace.edit("social-ads", {
    theme: "ace/theme/textmate",
    mode: "ace/mode/html",
    value: facebookPixel.value,
});

jQuery('form[action="options.php"]').submit(function(event) {
        event.preventDefault();
        var codeAnalytics = analytics.getValue();
        var codeSocial = social.getValue();
        googleAnalytics.value = codeAnalytics;
        facebookPixel.value = codeSocial;
        

        var formData = jQuery(this).serialize();
        var title = jQuery(this).attr('title');
        jQuery.ajax({
            type: 'POST',
            url: jQuery(this).attr('action'), // Posting to options.php
            data: formData,
            success: function(response) {
                alert(title+' sauvegardé !');
            },
            error: function() {
                alert(title+' Bug de sauvegarde');
            }
        });
    });


</script>