<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Elementor_Dynamic_Tag_Text extends \Elementor\Core\DynamicTags\Tag {
    public function get_name() {
        return 'text_variable';
    }

    public function get_title() {
        return esc_html__('Texte Variable', 'logia-helper');
    }

    public function get_group() {
        return ['Logia'];
    }

    public function get_categories() {
        return [\Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY];
    }

    protected function register_controls() {
        $this->add_control(
            'existing_variable_name',
            [
                'label' => esc_html__('Variable existante', 'logia-helper'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $this->get_existing_variables('TEXT_CATEGORY'),
                'default' => '',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'custom_variable_name',
            [
                'label' => esc_html__('Nom de la variable personnalisée', 'logia-helper'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Entrez le nom de la variable', 'logia-helper'),
                'label_block' => true,
            ]
        );
    }

    private function get_existing_variables($category) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'logia_helper_variables';
        $results = $wpdb->get_results($wpdb->prepare("SELECT variable_name FROM $table_name WHERE variable_category = %s", $category), ARRAY_A);
        $variables = ['' => esc_html__('Choisissez une variable', 'logia-helper')];
        foreach ($results as $result) {
            $variables[$result['variable_name']] = $result['variable_name'];
        }
        return $variables;
    }

    public function render() {
        $variable_name = $this->get_settings('existing_variable_name');
        if (empty($variable_name)) {
            $variable_name = $this->get_settings('custom_variable_name');
        }

        if (empty($variable_name)) {
            echo esc_html__('Aucune variable sélectionnée.', 'logia-helper');
            return;
        }

        global $wpdb;
        $table_name = $wpdb->prefix . 'logia_helper_variables';

        $variable = $wpdb->get_row($wpdb->prepare("SELECT variable_value FROM $table_name WHERE variable_name = %s AND variable_category = %s", $variable_name, 'TEXT_CATEGORY'));

        if ($variable) {
            echo $variable->variable_value;
        } else {
            echo esc_html__('Variable introuvable.', 'logia-helper');
        }
    }
}
?>
