<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Register Dynamic Tags
 *
 * @param \Elementor\Core\DynamicTags\Manager $dynamic_tags
 */
function register_logia_dynamic_tags($dynamic_tags) {
    require_once(__DIR__ . '/tags/class-elementor-dynamic-tag-text.php');
    require_once(__DIR__ . '/tags/class-elementor-dynamic-tag-url.php');
    require_once(__DIR__ . '/tags/class-elementor-dynamic-tag-color.php');
    // Add other tag classes as needed

    $dynamic_tags->register(new \Elementor_Dynamic_Tag_Text());
    $dynamic_tags->register(new \Elementor_Dynamic_Tag_URL());
    $dynamic_tags->register(new \Elementor_Dynamic_Tag_Color());
    // Register other tags as needed
}

add_action('elementor/dynamic_tags/register', 'register_logia_dynamic_tags');
