<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
?>




<!DOCTYPE html>
<html lang="en">
<head>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
</head>
<body class="bg-gray-100 p-6">
    <div class="container mx-auto">
        <h1 class="text-3xl font-bold mb-3">Créateur de variables Logia</h1>    
        <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <button onclick="addExamples()" class="my-3 bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            Ajouter les exemples Logia
        </button>   
        <form id="variableForm">
        <input type="hidden" id="variableNonce" value="<?php echo esc_attr(wp_create_nonce('save_variables')); ?>">
            <table class="w-full" id="variableTable">
                <thead>
                    <tr class="bg-gray-200 text-gray-600 uppercase text-sm leading-normal">
                        <th class="py-3 px-6 text-left">Nom de la variable</th>
                        <th class="py-3 px-6 text-left">Categorie</th>
                        <th class="py-3 px-6 text-left">Valeur</th>
                        <th class="py-3 px-6 text-center">Action</th>
                    </tr>
                </thead>
                <tbody id="variableTableBody">
                </tbody>
            </table>
            </form>
        </div>
        <button onclick="addRow()" class="mt-4 bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            Ajouter une variable
        </button>
        <button onclick="saveVariables()" class="mt-4 bg-green-500 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
            Sauvegarder les variables
        </button>
    </div>

    <script>
       
            const categories = {
                'Texte': 'TEXT_CATEGORY',
                'URL': 'URL_CATEGORY',
                'Nombre': 'NUMBER_CATEGORY',
                'Couleur': 'COLOR_CATEGORY'
            };

            const urlShortcuts = ['tel:', 'mailto:', 'https://map.apple.com/?daddr='];

            function addRow() {
                const tbody = document.getElementById('variableTableBody');
                const row = tbody.insertRow();
                row.className = 'border-b border-gray-200 hover:bg-gray-100';
                
                const cellName = row.insertCell(0);
                const cellCategory = row.insertCell(1);
                const cellValue = row.insertCell(2);
                const cellAction = row.insertCell(3);

                cellName.className = 'py-3 px-6 text-left flex items-center';
                cellName.innerHTML = '<div class="handle w-6 h-6 bg-gray-300 cursor-move rounded"><svg viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 8C10.3284 8 11 7.32843 11 6.5C11 5.67157 10.3284 5 9.5 5C8.67157 5 8 5.67157 8 6.5C8 7.32843 8.67157 8 9.5 8ZM9.5 14C10.3284 14 11 13.3284 11 12.5C11 11.6716 10.3284 11 9.5 11C8.67157 11 8 11.6716 8 12.5C8 13.3284 8.67157 14 9.5 14ZM11 18.5C11 19.3284 10.3284 20 9.5 20C8.67157 20 8 19.3284 8 18.5C8 17.6716 8.67157 17 9.5 17C10.3284 17 11 17.6716 11 18.5ZM15.5 8C16.3284 8 17 7.32843 17 6.5C17 5.67157 16.3284 5 15.5 5C14.6716 5 14 5.67157 14 6.5C14 7.32843 14.6716 8 15.5 8ZM17 12.5C17 13.3284 16.3284 14 15.5 14C14.6716 14 14 13.3284 14 12.5C14 11.6716 14.6716 11 15.5 11C16.3284 11 17 11.6716 17 12.5ZM15.5 20C16.3284 20 17 19.3284 17 18.5C17 17.6716 16.3284 17 15.5 17C14.6716 17 14 17.6716 14 18.5C14 19.3284 14.6716 20 15.5 20Z" fill="#121923"/></svg></div>';
                cellName.innerHTML += '<input type="text" placeholder="Nom" class="w-full px-2 py-1 rounded border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500">';
                
                cellCategory.className = 'py-3 px-6 text-left';
                let categorySelect = '<select onchange="updateValueInput(this)" class="w-full px-2 py-1 rounded border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500">';
                for (const [key, value] of Object.entries(categories)) {
                    categorySelect += `<option value="${value}">${key}</option>`;
                }
                categorySelect += '</select>';
                cellCategory.innerHTML = categorySelect;

                cellValue.className = 'py-3 px-6 text-left';
                cellValue.innerHTML = '<input type="text" placeholder="Value" class="w-full px-2 py-1 rounded border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500">';
                
                cellAction.className = 'py-3 px-6 text-center';
                cellAction.innerHTML = '<button onclick="deleteRow(this)" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded">X</button>';

                updateValueInput(cellCategory.firstChild);
                return row;
            }

            function deleteRow(button) {
                const row = button.closest('tr');
                row.parentNode.removeChild(row);
            }

            function updateValueInput(select) {
                const row = select.closest('tr');
                const valueCell = row.cells[2];
                const category = select.value;

                let input = '';
                const inputClass = 'w-full px-2 py-1 rounded border border-gray-300 focus:outline-none focus:ring-2 focus:ring-blue-500';
                switch (category) {
                    case 'NUMBER_CATEGORY':
                        input = `<input type="number" placeholder="123" class="${inputClass}">`;
                        break;
                    case 'TEXT_CATEGORY':
                        input = `<input type="text" placeholder="123 Rue de l'Exemple, <br> Paris, 75001" class="${inputClass}">`;
                        break;
                    case 'URL_CATEGORY':
                        input = `<input type="url" placeholder="tel:+331 23 45 67 89" class="${inputClass}">
                                <div class="mt-2 space-x-2">` +
                            urlShortcuts.map(shortcut => `<button type='button' onclick="addShortcut(this, '${shortcut}')" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-2 rounded text-xs">${shortcut}</button>`).join('') +
                            '</div>';
                        break;
                    case 'COLOR_CATEGORY':
                        input = `<input type="color" class="${inputClass} h-8">`;
                        break;
                }

                valueCell.innerHTML = input;
            }

            function addShortcut(button, shortcut) {
                const input = button.closest('td').querySelector('input');
                input.value = shortcut;
            }

            // Initialize SortableJS on the tbody
            new Sortable(document.getElementById('variableTableBody'), {
                animation: 150,
                handle: '.handle',
                ghostClass: 'sortable-ghost'
            });

            function addExamples(){
                var examples = [
                    {variable_name: 'Téléphone', variable_category: 'TEXT_CATEGORY', variable_value: '0123456789'},
                    {variable_name: 'Téléphone URL', variable_category: 'URL_CATEGORY', variable_value: 'tel:+33123456789'},
                    {variable_name: 'Adresse', variable_category: 'TEXT_CATEGORY', variable_value: "123 Rue de l'Exemple, <br> Paris, 75001"},
                    {variable_name: 'Adresse URL', variable_category: 'URL_CATEGORY', variable_value: 'https://maps.apple.com/?daddr=123 Rue de l\'Exemple, Paris, 75001'},
                    {variable_name: 'Email URL', variable_category: 'URL_CATEGORY', variable_value: 'mailto:example@domaine.com'},
                    {variable_name: 'Facebook URL', variable_category: 'URL_CATEGORY', variable_value: 'https://facebook.com'},
                    {variable_name: 'LinkedIn URL', variable_category: 'URL_CATEGORY', variable_value: 'https://linkedin.com'},
                    {variable_name: 'Instagram URL', variable_category: 'URL_CATEGORY', variable_value: 'https://instagram.com'},
                ];
                
                examples.forEach(example => {
                    const row = addRow();
                    row.cells[0].querySelector('input').value = example.variable_name;
                    row.cells[1].querySelector('select').value = example.variable_category;
                    updateValueInput(row.cells[1].querySelector('select'));
                    row.cells[2].querySelector('input').value = example.variable_value;
                });
            }

            window.addEventListener("DOMContentLoaded", function() {
                    if(logiaHelperVars.variables.length==0){
                    // check in local storage if it has already said no to the examples :
                    if (localStorage.getItem('logiaHelperExamples') === null) {
                        // if not, ask if they want to add the examples
                        if (confirm('Voulez-vous ajouter les exemples Logia ?')) {
                            addExamples();
                        }
                        // save in local storage that they said no
                        localStorage.setItem('logiaHelperExamples', 'no');
                    }
                
                }    else {
                    logiaHelperVars.variables.forEach(variable => {
                        const row = addRow();
                        row.cells[0].querySelector('input').value = variable.variable_name;
                        row.cells[1].querySelector('select').value = variable.variable_category;
                        updateValueInput(row.cells[1].querySelector('select'));
                        row.cells[2].querySelector('input').value = variable.variable_value;
                    });



                }
            });
       

   
    </script>
</body>
</html>
