jQuery(document).ready(function($) {
    window.saveVariables = function() {
        const tableBody = document.getElementById('variableTableBody');
        const rows = tableBody.getElementsByTagName('tr');
        const variables = [];
        for (let i = 0; i < rows.length; i++) {
            const cells = rows[i].getElementsByTagName('td');
            const name = cells[0].querySelector('input').value;
            const category = cells[1].querySelector('select').value;
            const value = cells[2].querySelector('input').value;
            variables.push({ name, category, value, order: i + 1 });
        }

        const nonce = document.getElementById('variableNonce').value;

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'save_variables',
                variables: variables,
                nonce: nonce
            },
            success: function(response) {
                alert('Les variables ont été enregistrées.');
            },
            error: function(response) {
                alert('Une erreur est survenue lors de l\'enregistrement des variables.');
            }
        });
    }
});
