<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


add_action('wp_ajax_save_variables', 'logia_helper_save_variables');

function logia_helper_save_variables() {
    check_ajax_referer('save_variables', 'nonce');

    if (!current_user_can('manage_options')) {
        wp_send_json_error('Unauthorized user', 403);
    }

    global $wpdb;
    $table_name = $wpdb->prefix . 'logia_helper_variables';

    $variables = isset($_POST['variables']) ? $_POST['variables'] : [];

    // Clear the existing variables
    $wpdb->query("TRUNCATE TABLE $table_name");

    foreach ($variables as $variable) {
        $variable_value = wp_unslash($variable['value']);
        $wpdb->insert(
            $table_name,
            [
                'variable_order' => intval($variable['order']),
                'variable_name' => sanitize_text_field($variable['name']),
                'variable_category' => sanitize_text_field($variable['category']),
                'variable_value' => wp_kses_post($variable_value)
            ]
        );
    }

    wp_send_json_success('Les variables ont été enregistrées avec succès');
}

