<?php
/*
Plugin Name: Logia Helper
Description: Conçu par Logia, ce plugin est un outil essentiel pour assurer la conformité RGPD et promouvoir les bonnes pratiques web. Il offre des solutions intégrées pour la gestion des consentements utilisateurs et la protection des données, tout en garantissant une expérience utilisateur respectueuse de la vie privée. Ce plugin est exclusif aux clients de Logia, offrant une solution personnalisée et sécurisée.
Version: 1.7.7
Author: Logia
Author Website: https://logia-inc.com
Licence: Utilisation exclusive pour les clients de Logia
*/


if (!defined('ABSPATH')) {
    exit; // Exit si accès direct
}




require 'plugin-update-checker/plugin-update-checker.php';

use YahnisElsts\PluginUpdateChecker\v5p3\Vcs\PluginUpdateChecker;
use YahnisElsts\PluginUpdateChecker\v5p3\Vcs\GitLabApi;

$myUpdateChecker = new PluginUpdateChecker(
    new GitLabApi('https://gitlab.cloudron.logia.app/root/logia-helper/'),
    __FILE__,
    'logia-helper'
);

$myUpdateChecker->setAuthentication('glpat-w-b27EpsQqrDiyssgq8v');
$myUpdateChecker->setBranch('main');


// Define the current database version
define('LOGIA_HELPER_DB_VERSION', '1.0');

// Function to run on plugin activation
function logia_helper_mon_plugin_activate() {
    dbCheck();
}
register_activation_hook(__FILE__, 'logia_helper_mon_plugin_activate');

// Function to create or update the database table
function dbCheck() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'logia_helper_variables';

    // Check if the table already exists
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        // Table not found, so create the table
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $table_name (
            id mediumint(9) NOT NULL AUTO_INCREMENT,
            variable_order mediumint(9) NOT NULL DEFAULT 0,
            variable_name text NOT NULL,
            variable_category text NOT NULL,
            variable_value text NOT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        // Check if table creation was successful
        if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            error_log('Failed to create table ' . $table_name);
        } else {
            update_option('logia_helper_db_version', LOGIA_HELPER_DB_VERSION);
            // error_log('Successfully created table ' . $table_name);
        }
    } else {
        // Table already exists, check if we need to update the version
        update_option('logia_helper_db_version', LOGIA_HELPER_DB_VERSION);
        error_log('Table ' . $table_name . ' already exists');
    }
}

// Function to check and update the database schema if necessary
function logia_helper_update_db_check() {
    if (get_option('logia_helper_db_version') != LOGIA_HELPER_DB_VERSION) {
        dbCheck();
    }
}
add_action('plugins_loaded', 'logia_helper_update_db_check');

// Register and enqueue plugin styles and scripts
function ccp_enqueue_scripts()
{
    $plugin_enabled = get_option('ccp_plugin_enabled');
    if ($plugin_enabled != 1) {
        return;
    }
    wp_enqueue_style('ccp-cookieconsent', plugin_dir_url(__FILE__) . 'cookieconsent.css');
    //  wp_enqueue_script('ccp-cookieconsent', plugin_dir_url(__FILE__) . 'cookieconsent.umd.js', [], false, true);
    if (get_option('context_menu_enabled')) {
        wp_enqueue_script('popper', 'https://unpkg.com/@popperjs/core@2', [], null, true);
        wp_enqueue_script('tippy', 'https://unpkg.com/tippy.js@6', ['popper'], null, true);
        wp_enqueue_script('context-menu-script', plugin_dir_url(__FILE__) . 'contextMenu/contextMenu.js', ['tippy'], null, true);
        wp_enqueue_style('context-menu-style', plugin_dir_url(__FILE__) . 'contextMenu/contextMenu.css');
    }
}
add_action('wp_enqueue_scripts', 'ccp_enqueue_scripts');


function pixel_initialize()
{
    $google_analytics = get_option('google_analytics');
    $facebook_pixel = get_option('facebook_pixel');
    $google_ads_enabled = get_option('google_ads_enabled');
    $explicit_google = get_option('explicit_google');
    $explicit_facebook = get_option('explicit_facebook');

    if (strlen($google_analytics)) {
        echo "<!-- Google Analytics -->";
   echo "<script>
        


        // Define dataLayer and the gtag function.
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}

        console.log('Consentement non donné pour les publicités');
        gtag('consent', 'default', {
            'ad_storage': 'denied',
            'ad_user_data': 'denied',
            'ad_personalization': 'denied',
     
        });
        console.log('Consentement non donné pour les analytics');
        gtag('consent', 'default', {
            'analytics_storage': 'denied',
        });
    
        </script>
        ";

        echo $google_analytics;


  


        echo "<!-- End Google Analytics -->";
    }
    if (strlen($facebook_pixel)) {
        echo "<!-- Facebook Pixel -->";
        echo $facebook_pixel;
        echo "<script>
        
        // check local storage
        if(localStorage.getItem('fb') != 'granted'){
            console.log('Consentement non donné pour le pixel Facebook');
            fbq('consent', 'revoke')
        }

        
        
        </script>";
        echo "<!-- End Facebook Pixel -->";
    }
}

add_action('wp_head', 'pixel_initialize');
// function addGoogleTagScript($codeSnippet)
// {

//     $modifiedSnippet = str_replace("<script", "<script type=\"text/html\" data-category=\"analytics\"", $modifiedSnippet);

//     return $modifiedSnippet;
// }


function my_plugin_load_textdomain()
{
    load_plugin_textdomain('logia-helper', false, basename(dirname(__FILE__)) . '/languages/');
}
add_action('init', 'my_plugin_load_textdomain');

function myplugin_enqueue_admin_styles($hook)
{

    // Use plugins_url() to correctly handle URL paths
    wp_enqueue_style('logia_helper_admin_styles', plugins_url('/css-fix.css', __FILE__));
}

add_action('admin_enqueue_scripts', 'myplugin_enqueue_admin_styles');



/**
 * Register new dynamic tag group
 *
 * @since 1.0.0
 * @param \Elementor\Core\DynamicTags\Manager $dynamic_tags_manager Elementor dynamic tags manager.
 * @return void
 */
function register_new_dynamic_tag_group($dynamic_tags_manager)
{

    $dynamic_tags_manager->register_group(
        'Logia',
        [
            'title' => esc_html__('Logia', 'logia-helper')
        ]
    );
}
add_action('elementor/dynamic_tags/register', 'register_new_dynamic_tag_group');


// add custom variables for dynamics tags in elementor 
function register_random_number_dynamic_tag($dynamic_tags_manager)
{

    require_once(__DIR__ . '/dynamic-tags/email_dynamic_tag.php');
    require_once(__DIR__ . '/dynamic-tags/phone_dynamic_tag.php');
    require_once(__DIR__ . '/dynamic-tags/address_dynamic_tag.php');
    require_once(__DIR__ . '/dynamic-tags/social_media_dynamic_tag.php');
    require_once(__DIR__ . '/dynamic-tags/avis_dynamic_tag.php');

    $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Email);
    $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Email_URL);
    $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Phone);
    $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Phone_URL);
    $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Address);
    $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Address_URL);
    $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Avis);

    if (get_option('logia-dynamic-tag-facebook') != false && get_option('logia-dynamic-tag-facebook') != "") {
        $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Facebook_URL);
    }
    if (get_option('logia-dynamic-tag-instagram') != false && get_option('logia-dynamic-tag-instagram') != "") {
        $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Instagram_URL);
    }
    if (get_option('logia-dynamic-tag-linkedin') != false && get_option('logia-dynamic-tag-linkedin') != "") {
        $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Linkedin_URL);
    }
    if (get_option('logia-dynamic-tag-youtube') != false && get_option('logia-dynamic-tag-youtube') != "") {
        $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Youtube_URL);
    }
    if (get_option('logia-dynamic-tag-youtube') != false && get_option('logia-dynamic-tag-youtube') != "") {
        $dynamic_tags_manager->register(new \Elementor_Dynamic_Tag_Youtube_URL);
    }
}
add_action('elementor/dynamic_tags/register', 'register_random_number_dynamic_tag');

function register_new_form_fields( $form_fields_registrar ) {

	require_once( __DIR__ . '/forms/fields/captcha-mandatory.php' );
    require_once( __DIR__ . '/forms/fields/action-fields.php' );

    $form_fields_registrar->register( new \Elementor_captcha_mandatory_field() );
    $form_fields_registrar->register( new \Elementor_action_field_custom_javascript() );

}
add_action( 'elementor_pro/forms/fields/register', 'register_new_form_fields' );





function add_new_forms_action( $form_actions_registrar ) {

	include_once( __DIR__ .  '/forms/actions/javascript.php' );

	$form_actions_registrar->register( new \Javascript_After_Submit() );

}
add_action( 'elementor_pro/forms/actions/register', 'add_new_forms_action' );






function my_plugin_enqueue_editor_scripts()
{
    wp_enqueue_script('elementor-logia-forms-js', plugins_url('/forms/elementor-forms.js', __FILE__), array('jquery'), '1.0', true);
}
// 
add_action('elementor/editor/after_enqueue_scripts', 'my_plugin_enqueue_editor_scripts');

// Add the cookies consent initialization script
function ccp_initialize_cookies_consent()
{
    $plugin_enabled = get_option('ccp_plugin_enabled');
    if ($plugin_enabled != 1) {
        return;
    }
    $main_color = get_option('ccp_main_color');
    $main_color_hover = get_option('ccp_main_color_hover');
    $layout = get_option('ccp_layout');
    $logo = esc_js(get_option('ccp_logo'));
    $title = esc_js(get_option('ccp_title'));
    $position = get_option('ccp_position');
    $transition = get_option('ccp_transition');
    $description = esc_js(get_option('ccp_description'));
    $darkmode = get_option('ccp_dark_button') ? 'true' : 'false';
    $swap_buttons = get_option('ccp_swap_buttons') ? 'true' : 'false';
    $domain_name = get_option('home');
    $importjs = plugin_dir_url(__FILE__) . 'cookieconsent.umd.js';

    $translations = array(
        'acceptAllBtn' => __('Accepter tout', 'logia-helper'),
        'showPreferencesBtn' => __('Gérer les préférences', 'logia-helper'),
        'acceptNecessaryBtn' => __('Tout rejeter', 'logia-helper'),
        'savePreferencesBtn' => __('Sauvegarder les préférences', 'logia-helper'),
        'closeModalBtn' => __('Fermer la fenêtre modale', 'logia-helper'),
        'useOfCookiesTitle' => __('Utilisation des cookies', 'logia-helper'),
        'useOfCookiesDescription' => __("J'utilise des cookies pour assurer les fonctionnalités de base du site web et pour améliorer votre expérience en ligne. Vous pouvez choisir pour chaque catégorie de se désinscrire/rejoindre chaque fois que vous le voulez.", 'logia-helper'),
        'strictlyNecessaryCookiesTitle' => __("Cookies strictement nécessaires", 'logia-helper'),
        'strictlyNecessaryBadge' => __("Actif", 'logia-helper'),
        'strictlyNecessaryCookiesDescription' => __("Ces cookies sont essentiels au bon fonctionnement de mon site web. Sans ces cookies, le site web ne fonctionnerait pas correctement.", 'logia-helper'),
        'analyticalCookiesTitle' => __("Cookies analytiques", 'logia-helper'),
        'analyticalCookiesDescription' => __("Ces cookies collectent des informations sur la manière dont vous utilisez le site web, les pages que vous avez visitées et les liens sur lesquels vous avez cliqué. Toutes les données sont anonymisées et ne peuvent pas être utilisées pour vous identifier.", 'logia-helper'),
        'advertisingCookiesTitle' => __("Cookies publicitaires", 'logia-helper'),
        'advertisingCookiesDescription' => __("Ces cookies sont utilisés pour vous fournir des publicités pertinentes sur d'autres sites web et pour mesurer l'efficacité de nos campagnes publicitaires. Ces cookies suivent les visiteurs sur les sites web et collectent des informations pour fournir des publicités personnalisées.", 'logia-helper'),
        'moreInformationTitle' => __('Plus d\'informations', 'logia-helper'),
        'moreInformationDescription' => __("Nous respectons votre vie privée et nous nous engageons à traiter vos données personnelles de manière responsable et confidentielle. Conformément au RGPD, nous collectons vos données personnelles uniquement après avoir obtenu votre consentement explicite, libre et éclairé. Vous avez le droit de consulter, de modifier ou de demander l'effacement de vos données personnelles à tout moment, et de retirer votre consentement au traitement de vos données. Pour plus d'informations sur l'utilisation de vos données et vos droits, veuillez consulter notre politique de confidentialité", 'logia-helper'),
        'columnNom' => __('Nom', 'logia-helper'),
        'columnDomaine' => __('Domaine', 'logia-helper'),
        'columnExpiration' => __('Expiration', 'logia-helper'),
        'columnDescription' => __('Description', 'logia-helper'),
        'columnType' => __('Type', 'logia-helper'),
        'googleAnalyticsDescription' => __('Google Analytics, utilisent des cookies pour recueillir des données sur les performances du site et les comportements des utilisateurs.', 'logia-helper'),
        'googleAdsDescription' => __('Google Ads, utilisent des cookies pour afficher des publicités personnalisées en fonction des visites antérieures de l\'utilisateur sur votre site web et sur d\'autres sites.', 'logia-helper'),
        'facebookAdsDescription' => __('Facebook Ads, utilisent des cookies pour optimiser les publicités basées sur les données de comportement des utilisateurs et leurs interactions sur notre site. Il aide à cibler les publicités de manière plus efficace et à fournir du contenu publicitaire pertinent et personnalisé aux utilisateurs.', 'logia-helper'),
        'cookiesPersistant' => __('Cookie persistant', 'logia-helper'),
        'googleAnalyticsTime' => __('2 ans', 'logia-helper'),
        'googleAdsTime' => __('2 ans', 'logia-helper'),
        'facebookAdsTime' => __('90 jours', 'logia-helper'),

    );


    // Replace the default initialization script with a PHP string

    // Now we are going to look at what pixels are integrated
    $google_analytics = get_option('google_analytics');
    $facebook_pixel = get_option('facebook_pixel');
    $google_ads_enabled = get_option('google_ads_enabled');
    $explicit_google = get_option('explicit_google');
    $explicit_facebook = get_option('explicit_facebook');


    $init_script = <<<EOT
<style>
:root {
    --cc-btn-primary-bg: {$main_color};
    --cc-btn-primary-hover-bg: {$main_color_hover};
    --cc-z-index: 999;
}
#cc-main [data-role="necessary"] {
    background: var(--cc-btn-secondary-bg);
    border-color: var(--cc-btn-secondary-border-color);
    color: var(--cc-btn-secondary-color);
} 

#cc-main [data-role="necessary"]:hover {
    background: var(--cc-btn-secondary-hover-bg);
    border-color: var(--cc-btn-secondary-hover-border-color);
    color: var(--cc-btn-secondary-hover-color);
} 
</style>
<script type="module">
var darkmode = {$darkmode};
if(darkmode){
    document.body.classList.toggle('c_darkmode');
}

import '{$importjs}';

// obtain cookieconsent plugin
var logo = '<img src="{$logo}" alt="Logo" loading="lazy" style="margin-left: -4px; margin-bottom: -5px; height: 35px">';
// run plugin with config object
CookieConsent.run({
    onConsent: function() {
        
       
            if(CookieConsent.acceptedCategory('analytics')) {  
                if(gtag){    
                 
                gtag('consent', 'update', {
                    'analytics_storage': 'granted'
                });
            
                // add to local storage
                localStorage.setItem('analytics', 'granted');
                console.log('Consentement donné pour les analytics');
            }
            }

            if(CookieConsent.acceptedCategory('marketing')){
                if(gtag){
                    
                 
               
                        gtag('consent', 'update', {
                            'ad_storage': 'granted',
                            'ad_user_data': 'granted',
                            'ad_personalization': 'granted',
                        });
                        // add to local storage
                
                localStorage.setItem('ad', 'granted');


                console.log('Consentement donné pour les publicités');
            }
                if(typeof fbq !== 'undefined'){
                    fbq('consent', 'grant');
              
                    // add to local storage
                    localStorage.setItem('fb', 'granted');
                    console.log('Consentement donné pour les pixels Facebook');
                }
            }  
        




    },
    guiOptions: {
        consentModal: {
            layout: "{$layout}",
            transition: '{$transition}',
            position: '{$position}',
            equalWeightButtons: true,
            flipButtons: {$swap_buttons},
        },
        preferencesModal: {
            layout: "box",
            position: "right",
            equalWeightButtons: true,
            flipButtons: false
        }
    },
    categories: {
        necessary: {
            readOnly: true
        },
        
EOT;

    if ($explicit_google == 1) {
        $init_script .= <<<EOT
        analytics: {},
EOT;
    }

    if ($explicit_facebook == 1 || $google_ads_enabled == 1) {
        $init_script .= <<<EOT
        marketing: {}
EOT;
    }

    $init_script .= <<<EOT
    },
    language: {
        default: "fr",
        autoDetect: "browser",
        translations: {
            fr: {
                consentModal: {
                    title: "{$title}",
                    description: "{$description}",
                    acceptAllBtn: "{$translations["acceptAllBtn"]}",
                    showPreferencesBtn: "{$translations["showPreferencesBtn"]}",
                },
                preferencesModal: {
                    title: logo,
                    acceptAllBtn: "{$translations["acceptAllBtn"]}",
                    acceptNecessaryBtn:     "{$translations["acceptNecessaryBtn"]}",
                    savePreferencesBtn:     "{$translations["savePreferencesBtn"]}",
                    closeIconLabel:        "{$translations["closeModalBtn"]}",
                    serviceCounterLabel: "Services",
                    sections: [
                        {
                            title: "{$translations["useOfCookiesTitle"]}",
                            description: "{$translations["useOfCookiesDescription"]}",
                        },
                        {
                            title: "{$translations["strictlyNecessaryCookiesTitle"]} <span class=\"pm__badge\">{$translations["strictlyNecessaryBadge"]}</span>",
                            description: "{$translations["strictlyNecessaryCookiesDescription"]}",
                            linkedCategory: "necessary"
                        },
EOT;

    if ($explicit_google == 1) {
        $init_script .= <<<EOT
{
title: "{$translations["analyticalCookiesTitle"]}",
description: "{$translations["analyticalCookiesDescription"]}",
linkedCategory: "analytics",
cookieTable: {
headers: {
    col1: "{$translations["columnNom"]}",
    col2: "{$translations["columnDomaine"]}",
    col4: "{$translations["columnDescription"]}",
    col6: "{$translations["columnType"]}",
    col5: "{$translations["columnExpiration"]}",
},
body: [
{
    col1: 'Google Analytics',
    col2: 'google.com',
    col4: '{$translations["googleAnalyticsDescription"]}',
    col6: '{$translations["cookiesPersistant"]}',
    col5: '{$translations["googleAnalyticsTime"]}',
}
]
}
}
,
EOT;
    }

    if ($explicit_facebook == 1 || $google_ads_enabled == 1) {
        $init_script .= <<<EOT
{
    title: "{$translations["advertisingCookiesTitle"]}",
    description: "{$translations["advertisingCookiesDescription"]}",
linkedCategory: "marketing",
cookieTable: {
headers: {
    col1: "{$translations["columnNom"]}",
    col2: "{$translations["columnDomaine"]}",
    col4: "{$translations["columnDescription"]}",
    col6: "{$translations["columnType"]}",
    col5: "{$translations["columnExpiration"]}",
},
body: [
EOT;

        if ($google_ads_enabled == 1) {
            $init_script .= <<<EOT
{
    col1: 'Google Ads',
    col2: 'google.com',
    col4: "{$translations["googleAdsDescription"]}",
    col6: '{$translations["cookiesPersistant"]}',
    col5: '{$translations["googleAdsTime"]}',
},
EOT;
        }

        if ($explicit_facebook == 1) {
            $init_script .= <<<EOT
{
    col1: 'Facebook Ads',
    col2: 'meta.com',
    col4: "{$translations["facebookAdsDescription"]}",
    col6: '{$translations["cookiesPersistant"]}',
    col5: '{$translations["facebookAdsTime"]}',
}, 
EOT;
        }
    }
    if ($explicit_facebook == 1 || $google_ads_enabled == 1) {
        $init_script .= <<<EOT
                                ]},
                            },
EOT;
    }

    $init_script .= <<<EOT
                        {
                            title: "{$translations["moreInformationTitle"]}",
                            description: "{$translations["moreInformationDescription"]}",
                        }
                    ]
                }
            }
        }
    }
});
</script>
EOT;

    echo $init_script;
}
add_action('wp_footer', 'ccp_initialize_cookies_consent');




function initialize_scrollbar_settings()
{
    $scrollbar_thumb_color = esc_js(get_option('scrollbar-thumb-color'));
    $scrollbar_thumb_color_hover = esc_js(get_option('scrollbar-thumb-color-hover'));
    $scrollbar_track_color = esc_js(get_option('scrollbar-track-color'));
    $scrollbar_width_style = esc_js(get_option('scrollbar-width-style'));
    $scrollbar_width = esc_js(get_option('scrollbar-width'));
    $scrollbar_border_radius = esc_js(get_option('scrollbar-border-radius'));
    $scrollbar_border_width = esc_js(get_option('scrollbar-border-width'));
    $scrollbar_border_style = esc_js(get_option('scrollbar-border-style'));
    $scrollbar_border_color = esc_js(get_option('scrollbar-border-color'));

    echo <<<EOT
<style>
/* ===== Scrollbar CSS ===== */
/* Firefox */

@supports (-moz-appearance:none) {

* {
    scrollbar-width: {$scrollbar_width_style};
    scrollbar-color: {$scrollbar_thumb_color} {$scrollbar_track_color};
}

}

/* Chrome, Edge, and Safari */
*::-webkit-scrollbar {
    width: {$scrollbar_width}px;
}

*::-webkit-scrollbar-track {
    background: {$scrollbar_track_color};
}

*::-webkit-scrollbar-thumb {
    background-color: {$scrollbar_thumb_color};
    border-radius: {$scrollbar_border_radius}px;
    border: {$scrollbar_border_width}px {$scrollbar_border_style} {$scrollbar_border_color};
}

*::-webkit-scrollbar:hover {
    background-color: {$scrollbar_thumb_color_hover};
  
}
</style>
EOT;
}

add_action('wp_footer', 'initialize_scrollbar_settings');

function initialize_caret_selection_settings()
{
    $caret_color = esc_js(get_option('caret-color'));
    $selected_text_color = esc_js(get_option('selection-text-color'));
    $selected_background_color = esc_js(get_option('selection-background-color'));

    echo <<<EOT
<style>
/* ===== Caret and Selection CSS ===== */
::selection {
    color: {$selected_text_color};
    background-color: {$selected_background_color};
}
input, textarea {
    caret-color: {$caret_color};
}

input:focus::placeholder {
    color: transparent!important;
}
*{
    accent-color: {$selected_background_color};
    -webkit-tap-highlight-color: {$selected_background_color}; 

}
</style>
EOT;
}

add_action('wp_footer', 'initialize_caret_selection_settings');



function addMetaThemeColor()
{
    $meta_theme_color = esc_js(get_option('theme-color'));

    echo "<meta name='theme-color' content='{$meta_theme_color}'>";
}

add_action('wp_head', 'addMetaThemeColor');


function logia_helper_menu_setup()
{
    // Créer le menu principal
    add_menu_page(
        'Logia Helper',            // Titre de la page
        'Logia Helper',            // Titre du menu
        'manage_options',          // Capacité requise
        'logia-helper-main',       // Slug du menu
        'ccp_admin_settings_page',  // Fonction pour afficher la page
        'dashicons-admin-tools',   // Icône du menu (vous pouvez choisir une icône différente)
        6                          // Position dans le menu
    );

    // Ajouter le sous-menu "Paramètre Logia"
    // add_submenu_page(
    //     'logia-helper-main',       // Slug du menu parent
    //     'Paramètre Logia',         // Titre de la page
    //     'Paramètre Logia',         // Titre du menu
    //     'manage_options',          // Capacité requise
    //     'cookies-consent-plugin',  // Slug du sous-menu
    //     'ccp_admin_settings_page'  // Fonction pour afficher la page
    // );

    // Ajouter le sous-menu "Initialisation"
    add_submenu_page(
        'logia-helper-main',       // Slug du menu parent
        'Initialisation',          // Titre de la page
        'Initialisation',          // Titre du menu
        'manage_options',          // Capacité requise
        'logia-helper-init',       // Slug du sous-menu
        'logia_helper_init_page'   // Fonction pour afficher la page
    );
    add_submenu_page(
        'logia-helper-main',       // Slug du menu parent
        'Logia Variables',          // Titre de la page
        'Logia Variables',          // Titre du menu
        'manage_options',          // Capacité requise
        'logia-helper-variables',       // Slug du sous-menu
        'logia_helper_logia_variables'   // Fonction pour afficher la page
    );

    // Ajouter le sous-menu "Pixel"
    add_submenu_page(
        'logia-helper-main',       // Slug du menu parent
        'Installation de Pixel',          // Titre de la page
        'Pixel Analytics/Ads/Meta',          // Titre du menu
        'manage_options',          // Capacité requise
        'logia-helper-pixel',       // Slug du sous-menu
        'logia_helper_pixel'   // Fonction pour afficher la page
    );


    add_submenu_page(
        'logia-helper-main',       // Slug du menu parent
        'Faq',          // Titre de la page
        'FAQ',          // Titre du menu
        'manage_options',          // Capacité requise
        'logia-helper-faq',       // Slug du sous-menu
        'logia_helper_faq'   // Fonction pour afficher la page
    );


}





// Hook pour ajouter le menu
add_action('admin_menu', 'logia_helper_menu_setup');


function logia_helper_faq()
{
    require_once(plugin_dir_path(__FILE__) . 'ganja/ganja-faq.php');
}


function logia_helper_logia_variables()

{
    global $wpdb;
    $table_name = $wpdb->prefix . 'logia_helper_variables';
    $variables = $wpdb->get_results("SELECT * FROM $table_name ORDER BY variable_order ASC");

    // Localize script to pass variables to JavaScript
    wp_localize_script('logia-helper-ajax-script', 'logiaHelperVars', array(
        'variables' => $variables,
        'nonce' => wp_create_nonce('save_variables')
    ));

    require_once(plugin_dir_path(__FILE__) . 'logia-tags/logia-tags.php');
}


function logia_helper_enqueue_scripts($hook) {
    
    if ($hook !== 'logia-helper_page_logia-helper-variables') {
        return;
    }


    wp_enqueue_script('logia-helper-ajax-script', plugin_dir_url(__FILE__) . 'logia-tags/ajax-variables.js', array('jquery'), null, true);
    wp_localize_script('logia-helper-ajax-script', 'ajaxurl', admin_url('admin-ajax.php'));
}
add_action('admin_enqueue_scripts', 'logia_helper_enqueue_scripts');



function logia_helper_pixel()
{

    require_once(plugin_dir_path(__FILE__) . 'pixels/pixels.php');

    // Enregistrer et mettre en file d'attente votre script
    //wp_enqueue_script('initializer-script', plugins_url('/initializer/initializer.js', __FILE__), array('jquery'), '1.0.0', true);


    /*
    // Créer une nonce
    $nonce = wp_create_nonce('logia-helper-initializer');

    // Transmettre la nonce et l'URL AJAX au script
    wp_localize_script('initializer-script', 'ajaxObject', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => $nonce
    ));*/
}





function logia_helper_init_page()
{
    echo '<h1 class="sm:text-6xl">Initialisation</h1>';
    require_once(plugin_dir_path(__FILE__) . 'initializer/initializer.php');

    // Enregistrer et mettre en file d'attente votre script
    wp_enqueue_script('initializer-script', plugins_url('/initializer/initializer.js', __FILE__), array('jquery'), '1.0.0', true);

    // Créer une nonce
    $nonce = wp_create_nonce('logia-helper-initializer');

    // Transmettre la nonce et l'URL AJAX au script
    wp_localize_script('initializer-script', 'ajaxObject', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => $nonce
    ));
}


// Fonction pour afficher le contenu de la page principale
function logia_helper_main_page()
{
    echo '<h1>Logia Helper Dashboard</h1>';
    // Contenu de la page principale
}



// Register plugin settings
function ccp_register_settings()
{
    cookies_register_settings();
    scrollbar_register_settings();
    caret_register_settings();
    meta_theme_register_settings();
    register_sitemap_menu_setting();
    register_context_menu_setting();
    fonctionnalites_register_settings();
    pixel_register_settings();
    global_var_register_settings();
}

function global_var_register_settings()
{

    register_setting('global-var-settings', 'logia-dynamic-tag-email');
    register_setting('global-var-settings', 'logia-dynamic-tag-avis');
    register_setting('global-var-settings', 'logia-dynamic-tag-phone');
    register_setting('global-var-settings', 'logia-dynamic-tag-address');

    register_setting('global-var-settings', 'logia-dynamic-tag-facebook');
    register_setting('global-var-settings', 'logia-dynamic-tag-instagram');
    register_setting('global-var-settings', 'logia-dynamic-tag-linkedin');
    register_setting('global-var-settings', 'logia-dynamic-tag-youtube');
    register_setting('global-var-settings', 'logia-dynamic-tag-twitter');
}



function pixel_register_settings()
{
    register_setting('pixels-settings', 'google_analytics');
    register_setting('pixels-settings', 'google_ads_enabled', array(
        'default' => 0,
    ));
    // default checked explicit google
    register_setting("pixels-settings", "explicit_google", array(
        'default' => 0,
    ), 'intval');
    register_setting('pixels-settings', 'facebook_pixel');
    register_setting("pixels-settings", "explicit_facebook", array(
        'default' => 0,
    ), 'intval');
}


function register_sitemap_menu_setting()
{
    register_setting('sitemap-settings', 'sitemap_menu');
}

function register_context_menu_setting()
{
    register_setting('custom-context-menu', 'context_menu_enabled');
    register_setting('custom-context-menu', 'context_menu_text_color', array(
        'default' => '#4a5568',
    ));
    register_setting('custom-context-menu', 'context_menu_background_color', array(
        'default' => '#ffffff',
    ));
    register_setting('custom-context-menu', 'context_menu_hover_color', array(
        'default' => '#f7fafc',
    ));
    register_setting('custom-context-menu', 'custom_cta_button');
    register_setting('custom-context-menu', 'cta_button_text');
    register_setting('custom-context-menu', 'cta_button_url');
    register_setting('custom-context-menu', 'facebook_url');
    register_setting('custom-context-menu', 'instagram_url');
    register_setting('custom-context-menu', 'linkedin_url');
    register_setting('custom-context-menu', 'youtube_url');
    register_setting('custom-context-menu', 'email_address');
    register_setting('custom-context-menu', 'phone_number');
}



function cookies_register_settings()
{
    register_setting('ccp-settings-group', 'ccp_logo');
    register_setting('ccp-settings-group', 'ccp_main_color');
    register_setting('ccp-settings-group', 'ccp_main_color_hover');
    register_setting('ccp-settings-group', 'ccp_layout');
    register_setting('ccp-settings-group', 'ccp_title');
    register_setting('ccp-settings-group', 'ccp_position');
    register_setting('ccp-settings-group', 'ccp_transition');
    register_setting('ccp-settings-group', 'ccp_swap_buttons');
    register_setting('ccp-settings-group', 'ccp_dark_button');
    register_setting('ccp-settings-group', 'ccp_description');
    register_setting('ccp-settings-group', 'ccp_plugin_enabled');

    if (false === get_option('ccp_description')) {
        add_option('ccp_description', 'Salut, ce site web utilise des cookies essentiels pour assurer son bon fonctionnement et des cookies de suivi pour comprendre comment vous interagissez avec lui. Ceux-ci ne seront définis qu\'après approbation.');
    }
    if (false === get_option('ccp_title')) {
        add_option('ccp_title', '🍪 J\'utilise des cookies');
    }
}
function scrollbar_register_settings()
{
    register_setting('scrollbar-settings-group', 'scrollbar-thumb-color');
    register_setting('scrollbar-settings-group', 'scrollbar-thumb-color-hover');
    register_setting('scrollbar-settings-group', 'scrollbar-track-color');
    register_setting('scrollbar-settings-group', 'scrollbar-width-style');
    register_setting('scrollbar-settings-group', 'scrollbar-width');
    register_setting('scrollbar-settings-group', 'scrollbar-border-radius');
    register_setting('scrollbar-settings-group', 'scrollbar-border-width');
    register_setting('scrollbar-settings-group', 'scrollbar-border-style');
    register_setting('scrollbar-settings-group', 'scrollbar-border-color');
}



function caret_register_settings()
{
    register_setting('caret-settings-group', 'caret-color');
    register_setting('caret-settings-group', 'selection-text-color');
    register_setting('caret-settings-group', 'selection-background-color');
}


function meta_theme_register_settings()
{
    register_setting('theme-settings-group', 'theme-color');
}

add_action('admin_init', 'ccp_register_settings');


function fonctionnalites_register_settings()
{
    register_setting('fonctionnalites-settings-group', 'disable-articles');
    register_setting('fonctionnalites-settings-group', 'disable-comments');
}


function ccp_admin_settings_page()
{
    wp_enqueue_media();
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('wp-color-picker');
    wp_enqueue_script('wp-color-picker-script-handle', plugins_url('wp-color-picker-script.js', __FILE__), array('wp-color-picker'), false, true);
    require_once(plugin_dir_path(__FILE__) . 'admin-settings.php');
}


// Check for Divi theme (by Elegant Themes)
if (function_exists('et_setup_theme')) {

    // Remove default viewport meta from Divi
    function remove_divi_actions()
    {
        remove_action('wp_head', 'et_add_viewport_meta');
    }
    add_action('init', 'remove_divi_actions');

    // Add custom viewport meta for Divi
    function et_new_viewport_meta()
    {
        echo '<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=1" />';
    }
    add_action('wp_head', 'et_new_viewport_meta', 15);
}

// Check for Elementor Plugin
if (did_action('elementor/loaded')) {

    // Modify the viewport content for Elementor
    function custom_hello_elementor_viewport_content()
    {
        return 'width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=1';
    }
    add_filter('hello_elementor_viewport_content', 'custom_hello_elementor_viewport_content');
}


function limiter_les_revisions($num, $post)
{
    return 5; // Limite à 5 révisions
}

add_filter('wp_revisions_to_keep', 'limiter_les_revisions', 10, 2);



include plugin_dir_path(__FILE__) . '/shortcode.php';
// Enregistrement d'un hook pour les shortcodes personnalisés
include plugin_dir_path(__FILE__) . 'contextMenu/contextMenu.php';
include plugin_dir_path(__FILE__) . 'initializer/initializer-function.php';
include plugin_dir_path(__FILE__) . 'initializer/ajax-initializer-function.php';
include plugin_dir_path(__FILE__) . 'logia-tags/ajax-tags.php';
include plugin_dir_path(__FILE__) . 'logia-tags/logia_variable_dynamic_tag.php';
include  plugin_dir_path(__FILE__) . 'ganja/ganja-code.php';
