<?php
$existingUser = username_exists($user['username']);
$cursorClass = $existingUser ? 'cursor-not-allowed' : '';
?>

<li>
    <label class="inline-flex items-center justify-between w-full p-5 text-gray-500 bg-white border-2 border-gray-200 rounded-lg <?= $cursorClass ?> dark:hover:text-gray-300 dark:border-gray-700 peer-checked:border-blue-600 hover:text-gray-600 dark:peer-checked:text-gray-300 peer-checked:text-gray-600 hover:bg-gray-90 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-900" for="<?= $user['username'] ?>"> 
        <?php if ($existingUser) : ?>
            <span class="flex items-center">
                <svg class="w-4 h-4 text-green-500 fill-current" viewBox="0 0 20 20">
                    <path d="M0 11l2-2 5 5L18 3l2 2L7 18z" />
                </svg>
            </span>
            <span class="flex-1 ms-3 whitespace-nowrap"><?= $user['name'] ?></span>
            <span class="inline-flex items-center justify-center px-2 py-0.5 ms-3 text-xs font-medium text-gray-500 bg-gray-200 rounded dark:bg-gray-700 dark:text-gray-400"><?= $user['role'] ?></span>
            <span class="inline-flex items-center justify-center px-2 py-0.5 ms-3 text-xs font-medium text-green-500 bg-green-200 rounded dark:bg-green-700 dark:text-green-400 opacity-75">Ajouté</span>
        <?php else : ?>
            <input type="checkbox" id="<?= $user['username'] ?>" data-user="<?= $user['username'] ?>" name="user-selected" value="<?= $user['username'] ?>" class="hidden peer" required="">
            <span class="flex-1 ms-3 whitespace-nowrap"><?= $user['name'] ?></span>
            <span class="inline-flex items-center justify-center px-2 py-0.5 ms-3 text-xs font-medium text-gray-500 bg-gray-200 rounded dark:bg-gray-700 dark:text-gray-400"><?= $user['role'] ?></span>
        <?php endif; ?>
    </label>
</li>