<?php
$local = $plugin["is_local"];
$pluginLocalFile = "";
if(isset($plugin["local_file"])){
    $pluginLocalFile = $plugin["local_file"];
}
$pluginSlug = $plugin["plugin_slug"];
$pluginFullSlug = isset($plugin["plugin_full_slug"]) ? $plugin["plugin_full_slug"] : '';
$pluginName = $plugin["plugin_name"];
?>

<details class="p-4 rounded-lg bg-gray-50 dark:bg-gray-800" open="">
    <summary class="flex justify-between items-center text-white">
        <div class="title">
             <?= $pluginName ?>
        </div>
        
        <?php

        if (is_plugin_installed($pluginSlug)) {

            // Check if the plugin is activated 
            if (is_plugin_activated($pluginSlug)) {
                echo '<span class="text-green-500 text-right">Installé & Activé</span>';
            } else {
                echo '<span class="text-green-500 text-right">Installé</span>';
            }
        } else {
            echo '<div class="install-plugin-btns flex items-center space-x-2">';
            echo '<button data-local-file-slug="'.$pluginLocalFile.'" data-local="'.$local.'" class="install-plugin-btn px-4 py-2 text-sm font-medium text-white rounded-lg bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800" data-activated="0" data-plugin-slug="' . $pluginSlug . '">Installer</button>';
            echo '<button data-local-file-slug="'.$pluginLocalFile.'" data-local="'.$local.'" class="install-plugin-btn px-4 py-2 text-sm font-medium text-white rounded-lg bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800" data-activated="1" data-plugin-full-slug="' . $pluginFullSlug . '" data-plugin-slug="' . $pluginSlug . '">Installer et activer</button>';
            echo '</div>';
        }
        ?>
    </summary>
    <div class="output text-white">
    </div>
</details>