<?php
                    $users = [
                        [
                            'name' => 'Giani Navette',
                            'username' => 'GianiNavette',
                            'role' => 'Administrateur'
                        ],
                        [
                            'name' => 'Lony Lombard',
                            'username' => 'LonyLombard',
                            'role' => 'Administrateur'
                        ],
                        [
                            'name' => 'Dylan Lombard',
                            'username' => 'Dydz',
                            'role' => 'Administrateur'
                        ],
                        [
                            'name' => 'Tom Bridet',
                            'username' => 'TomBridet',
                            'role' => 'Intégrateur Web'
                        ],
                        [
                            'name' => 'Theo Schwilden',
                            'username' => 'TheoSchwilden',
                            'role' => 'Développeur Web'
                        ]
                    ];

                   

                    $pluginArray = [
                        [
                            'plugin_slug' => 'elementor',
                            'plugin_name' => 'Elementor',
                            'is_local' => "false"
                        ],
                        [
                            'plugin_slug' => 'elementor-pro',
                            'plugin_name' => 'Elementor Pro',
                            'is_local' => "true",
                            'local_file' => 'elementor-pro-3.14.1.zip'
                        ],
                        [
                            'plugin_slug' => 'essential-addons-for-elementor-lite',
                            'plugin_name' => 'Essential Addons (Elementor Plugin)',
                            'is_local' => "false"
                        ],
                        [
                            'plugin_slug' => 'essential-addons-elementor',
                            'plugin_name' => 'Essential Addons (Elementor Plugin) Pro',
                            'plugin_full_slug' => 'essential-addons-elementor/essential_adons_elementor.php',
                            'is_local' => "true",
                            'local_file' => 'essential-addons-elementor.zip'
                        ],
                        
                        [
                            'plugin_slug' => 'unlimited-elements-for-elementor-premium',
                            'plugin_full_slug' => 'unlimited-elements-for-elementor-premium/unlimited-elements-pro.php',
                            'plugin_name' => 'Unlimited Elements (Elementor Plugin)',
                            'is_local' => "true",
                            'local_file' => 'unlimited-elements-for-elementor-premium.1.5.85.zip'
                        ]
                        ,[
                            'plugin_slug' => 'seo-by-rank-math',
                            'plugin_full_slug' => 'seo-by-rank-math/rank-math.php',
                            'plugin_name' => 'Rank Math',
                            'is_local' => "false"
                        ],[
                            'plugin_slug' => 'gallery-custom-links',
                            'plugin_name' => 'Custom Links in gallery',
                            'is_local' => "false"
                        ],
                        [

                            'plugin_slug' => 'happyfiles-pro',
                            'plugin_name' => 'Happy Files (Dossier pour les médias et les pages)',
                            'plugin_full_slug' => 'happyfiles-pro/happyfiles-pro.php',
                            'local_file' => 'happyfiles-pro.zip',
                            'is_local' => "true"
                        ],
                        [

                            'plugin_slug' => 'advanced-custom-fields-pro',
                            'plugin_name' => 'ACF Pro (Création de type de publication et des champs personnalisées)',
                            'plugin_full_slug' => 'advanced-custom-fields-pro/acf.php',
                            'local_file' => 'advanced-custom-fields-pro.zip',
                            'is_local' => "true"
                        ],
                        [

                            'plugin_slug' => 'uipress',
                            'plugin_name' => 'UIPress',
                            'local_file' => 'uipress.2.4.1.zip',
                            'is_local' => "true"
                        ],
                        [
                            'plugin_slug' => 'wp-rocket',
                            'plugin_name' => 'WP Rocket',
                            'local_file' => 'wp-rocket_3.11.5.zip',
                            'is_local' => "true"
                        ],
                        [
                            'plugin_slug' => 'custom-links-in-elementor-image-carousel',	
                            'plugin_name' => 'Lien personnalisée dans carousel Elementor',
                            'is_local' => "false"
                        ],
                        [
                            'plugin_slug' => 'pdfjs-viewer-for-elementor',	
                            'plugin_name' => 'PDFjs viewer for Elementor & Gutenberg',
                            'is_local' => "false"
                        ],
                        [
                            'plugin_slug' => 'all-in-one-wp-security-and-firewall',
                            'plugin_full_slug' => 'all-in-one-wp-security-and-firewall/wp-security.php',
                            'plugin_name' => 'All-In-One Security (AIOS) – Security and Firewall',
                            'is_local' => "false"
                        ],
                        [
                            'plugin_slug' => 'favicon-by-realfavicongenerator',	
                            'plugin_full_slug' => 'favicon-by-realfavicongenerator/favicon.php',
                            'plugin_name' => 'Favicon by RealFaviconGenerator',
                            'is_local' => "false"
                        ],
                        [
                            'plugin_slug' => 'complianz-terms-conditions',	
                            'plugin_name' => 'Complianz – (Mentions Légales et CGV)',
                            'is_local' => "false"
                        ],

                      
                        ];
                    
                        $pluginArrayWooCommerce = [
                            [
                                'plugin_slug' => 'easy-login-woocommerce',	
                                'plugin_name' => 'Popup de connexion WooCommerce',
                                'is_local' => "false"
                            ],
                            [
                                'plugin_slug' => 'kadence-woocommerce-email-designer',	
                                'plugin_name' => 'Kadence (Personnalisation des emails WooCommerce)',
                                'is_local' => "false"
                            ],
    
                        ];

                    function is_plugin_installed($plugin_slug) {
                        $plugin_path = WP_PLUGIN_DIR . '/' . $plugin_slug;
                    
                        if (is_dir($plugin_path)) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                    
                    function is_plugin_activated($plugin_dossier) {
                        $plugins = get_plugins();
                    
                        foreach ($plugins as $plugin_path => $plugin) {
                            // Vérifie si le chemin du plugin contient le nom du dossier du plugin
                            if (strpos($plugin_path, $plugin_dossier . '/') === 0 && is_plugin_active($plugin_path)) {
                                return true;
                            }
                        }
                    
                        return false;
                    }

                    function is_theme_installed($theme_slug) {
                        $theme_path = get_theme_root() . '/' . $theme_slug;

                        if (is_dir($theme_path)) {
                            return true;
                        } else {
                            return false;
                        }
                    }

                    function is_theme_activated($theme_slug) {
                        $active_theme = wp_get_theme();

                        if ($active_theme->get_stylesheet() === $theme_slug) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                    

                    ?>




<script src="https://cdn.tailwindcss.com"></script>

<div class="mx-2 my-2 flex-column space-y-3">
    <!-- Start coding here -->
    <div class="relative overflow-hidden bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        <div class="flex-row items-center justify-between p-4 space-y-3 sm:flex sm:space-y-0 sm:space-x-4">
            <div>
                <h5 class="mr-3 font-semibold dark:text-white">Utilisateur Logia</h5>
                <p class="text-gray-500 dark:text-gray-400">Ajouter les utilisateurs Logia</p>
            </div>
            <?php 
               $added_users = 0;
               foreach ($users as $user) {
                   if (username_exists($user['username'])) {
                       $added_users++;
                   }
               }
            ?>
            <button type="button" data-modal-target="crypto-modal" data-modal-toggle="crypto-modal" class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg <?php echo ($added_users < count($users)) ? 'bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800' : 'bg-gray-400 cursor-not-allowed'; ?>">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5 mr-2 -ml-1" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                    <path d="M8 9a3 3 0 100-6 3 3 0 000 6zM8 11a6 6 0 016 6H2a6 6 0 016-6zM16 7a1 1 0 10-2 0v1h-1a1 1 0 100 2h1v1a1 1 0 102 0v-1h1a1 1 0 100-2h-1V7z" />
                </svg>
                <?php
                    if ($added_users == count($users)) {
                        echo "Utilisateurs ajoutés (5/5)";
                    } else {
                        echo "Ajouter les utilisateurs (" . $added_users . "/5)";
                    }
                ?>
            </button>
        </div>
    </div>
    <div class="relative overflow-hidden bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        <div class="flex-row items-center justify-between p-4 space-y-3 sm:flex sm:space-y-0 sm:space-x-4">
            <div>
                <h5 class="mr-3 font-semibold dark:text-white">SSL</h5>
                <p class="text-gray-500 dark:text-gray-400">Passer le site internet vers https pour la sécurité</p>
            </div>
            <?php
                $site_url = get_site_url();
                $is_https = strpos($site_url, 'https://') === 0;
            ?>
            <button type="button" data-modal-target="popup-modal" data-modal-toggle="popup-modal" class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg <?php echo $is_https ? 'bg-gray-400 cursor-not-allowed' : 'bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800'; ?>" <?php echo $is_https ? 'disabled' : ''; ?>>
                <svg class="h-3.5 w-3.5 mr-2 -ml-1" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 20">
                    <path d="M14 7h-1.5V4.5a4.5 4.5 0 1 0-9 0V7H2a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2Zm-5 8a1 1 0 1 1-2 0v-3a1 1 0 1 1 2 0v3Zm1.5-8h-5V4.5a2.5 2.5 0 1 1 5 0V7Z"/>
                </svg>
                <?php echo $is_https ? 'Site déjà en HTTPS' : 'Passer le site en HTTPS'; ?>
            </button>
        </div>
    </div>
    <div class="relative overflow-hidden bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        <div class="flex-row items-center justify-between p-4 space-y-3 sm:flex sm:space-y-0 sm:space-x-4">
            <div>
                <h5 class="mr-3 font-semibold dark:text-white">Plugin</h5>
                <p class="text-gray-500 dark:text-gray-400">Ajouter les plugins importants pour le dévéloppement du site internet</p>
            </div>
            <button data-modal-target="plugin-modal" data-modal-toggle="plugin-modal" type="button" class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800">
            <svg class="h-3.5 w-3.5 mr-2 -ml-1" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 18 18">
    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 14h6m-3 3v-6M1.857 1h4.286c.473 0 .857.384.857.857v4.286A.857.857 0 0 1 6.143 7H1.857A.857.857 0 0 1 1 6.143V1.857C1 1.384 1.384 1 1.857 1Zm10 0h4.286c.473 0 .857.384.857.857v4.286a.857.857 0 0 1-.857.857h-4.286A.857.857 0 0 1 11 6.143V1.857c0-.473.384-.857.857-.857Zm-10 10h4.286c.473 0 .857.384.857.857v4.286a.857.857 0 0 1-.857.857H1.857A.857.857 0 0 1 1 16.143v-4.286c0-.473.384-.857.857-.857Z"/>
  </svg>



                    Ajouter les plugins
            </button>
        </div>
    </div> 

    <div class="relative overflow-hidden bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        <div class="flex-row items-center justify-between p-4 space-y-3 sm:flex sm:space-y-0 sm:space-x-4">
            <div>
                <h5 class="mr-3 font-semibold dark:text-white">Theme</h5>
                <p class="text-gray-500 dark:text-gray-400">L'installation d'un thème enfant est essentiel pour la modification internet d'un site internet</p>
            </div>
            <button data-modal-target="theme-modal" data-modal-toggle="theme-modal" type="button" class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800">
  <svg class="h-3.5 w-3.5 mr-2 -ml-1 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 21 21">
    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.15 5.6h.01m3.337 1.913h.01m-6.979 0h.01M5.541 11h.01M15 15h2.706a1.957 1.957 0 0 0 1.883-1.325A9 9 0 1 0 2.043 11.89 9.1 9.1 0 0 0 7.2 19.1a8.62 8.62 0 0 0 3.769.9A2.013 2.013 0 0 0 13 18v-.857A2.034 2.034 0 0 1 15 15Z"/>
  </svg>


                    Ajouter un thème enfant
            </button>
        </div>
    </div> 
    <div class="relative overflow-hidden bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        <div class="flex-row items-center justify-between p-4 space-y-3 sm:flex sm:space-y-0 sm:space-x-4">
            <div>
                <h5 class="mr-3 font-semibold dark:text-white">Fonctionnalités</h5>
                <p class="text-gray-500 dark:text-gray-400">Désactiver les fonctionnalités utilisés par WordPress</p>
            </div>
            <button data-modal-target="function-modal" data-modal-toggle="function-modal" type="button" class="flex items-center justify-center px-4 py-2 text-sm font-medium text-white rounded-lg bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800">
  <svg class="h-3.5 w-3.5 mr-2 -ml-1 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 21 21">
    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.15 5.6h.01m3.337 1.913h.01m-6.979 0h.01M5.541 11h.01M15 15h2.706a1.957 1.957 0 0 0 1.883-1.325A9 9 0 1 0 2.043 11.89 9.1 9.1 0 0 0 7.2 19.1a8.62 8.62 0 0 0 3.769.9A2.013 2.013 0 0 0 13 18v-.857A2.034 2.034 0 0 1 15 15Z"/>
  </svg>


                    Voir les options
            </button>
        </div>
    </div> 
</div>

<h2>
    Liens rapide
</h2>
<?php  
$page_home_id = get_option('page_on_front');?>

    <div class="items-center justify-center space-y-4 sm:flex sm:space-y-0 sm:space-x-4 rtl:space-x-reverse">
        <a href="<?= admin_url('options-reading.php'); ?>" target="_blank" class="relative w-full hover:text-white focus:text-white sm:w-auto bg-gray-800 hover:bg-gray-700 focus:ring-4 focus:outline-none focus:ring-gray-300 text-white rounded-lg inline-flex items-center justify-center px-4 py-2.5 dark:bg-gray-700 dark:hover:bg-gray-600 dark:focus:ring-gray-700">
                <svg class="w-3 h-3 mr-3 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                    <path d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z"/>
                </svg>
            <div class="text-left rtl:text-right flex flex-col items-start">
                <span class="bg-red-100 text-white inline text-xs font-medium mb-2 px-2.5 py-0.5 rounded-full dark:bg-red-900 dark:text-red-100">Requis</span>
                <div class="-mt-1 font-sans text-s font-semibold">Modifier la page principale</div>
            </div>
            <?php if(!$page_home_id){ ?>
            <div class="absolute inline-flex items-center justify-center w-4 h-4 text-xs font-bold text-white bg-red-500 border-2 border-white rounded-full -top-2 -end-2 dark:border-gray-900"></div>
            <?php } else { ?>
                <div class="absolute inline-flex items-center justify-center w-4 h-4 text-xs font-bold text-white bg-green-500 border-2 border-white rounded-full -top-1 -end-1"></div>
            <?php } ?>
        </a>

        <?php
// find what type of structure the permalink is
$permastruct = get_option('permalink_structure');
// if it's not the default, then we know we have a custom permalink structure
if ($permastruct != '/%postname%/') {
    $custom_permalinks = true;
} else {
    $custom_permalinks = false;
}

?>
        <a href="<?= admin_url('options-permalink.php'); ?>" target="_blank" class="relative w-full hover:text-white focus:text-white sm:w-auto bg-gray-800 hover:bg-gray-700 focus:ring-4 focus:outline-none focus:ring-gray-300 text-white rounded-lg inline-flex items-center justify-center px-4 py-2.5 dark:bg-gray-700 dark:hover:bg-gray-600 dark:focus:ring-gray-700">
        <svg class="w-3 h-3  mr-3 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 18 18">
    <path d="M15.045.007 9.31 0a1.965 1.965 0 0 0-1.4.585L.58 7.979a2 2 0 0 0 0 2.805l6.573 6.631a1.956 1.956 0 0 0 1.4.585 1.965 1.965 0 0 0 1.4-.585l7.409-7.477A2 2 0 0 0 18 8.479v-5.5A2.972 2.972 0 0 0 15.045.007Zm-2.452 6.438a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"/>
  </svg>
            <div class="text-left rtl:text-right flex flex-col items-start">
                <span class="bg-red-100 text-white inline text-xs font-medium mb-2 px-2.5 py-0.5 rounded-full dark:bg-red-900 dark:text-red-100">Requis</span>
                <div class="-mt-1 font-sans text-s font-semibold">Modifier structure des permaliens</div>
            </div>
            <?php if($custom_permalinks){ ?>
            <div class="absolute inline-flex items-center justify-center w-4 h-4 text-xs font-bold text-white bg-red-500 border-2 border-white rounded-full -top-2 -end-2 dark:border-gray-900"></div>
            <?php } else { ?>
                <div class="absolute inline-flex items-center justify-center w-4 h-4 text-xs font-bold text-white bg-green-500 border-2 border-white rounded-full -top-1 -end-1"></div>
            <?php } ?>
        </a>
       
<?php 


// Your code here

// Check if the option exists and if the aiowps_login_page_slug index is set
if (get_option("aio_wp_security_configs") && isset(get_option("aio_wp_security_configs")["aiowps_login_page_slug"])) {
    // Check if the length of aiowps_login_page_slug is 0
    if (strlen(get_option("aio_wp_security_configs")["aiowps_login_page_slug"]) === 0) {
        $configured = false;
    } else {
        $configured = true;
    }
} else {
    $configured = false;
}
?>
        <a href="<?= admin_url('/admin.php?page=aiowpsec_brute_force'); ?>" target="_blank" class="relative w-full hover:text-white focus:text-white sm:w-auto bg-gray-800 hover:bg-gray-700 focus:ring-4 focus:outline-none focus:ring-gray-300 text-white rounded-lg inline-flex items-center justify-center px-4 py-2.5 dark:bg-gray-700 dark:hover:bg-gray-600 dark:focus:ring-gray-700">
        <svg class="w-3 h-3 mr-3 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.5 8V4.5a3.5 3.5 0 1 0-7 0V8M8 12.167v3M2 8h12a1 1 0 0 1 1 1v9a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1Z"/>
  </svg>
            <div class="text-left rtl:text-right flex flex-col items-start">
                <span class="bg-red-100 text-white inline text-xs font-medium mb-2 px-2.5 py-0.5 rounded-full dark:bg-red-900 dark:text-red-100">Requis</span>
                <div class="-mt-1 font-sans text-s font-semibold">Changer wp-admin par un autre lien</div>
            </div>
            <?php if($configured){ ?>
                <div class="absolute inline-flex items-center justify-center w-4 h-4 text-xs font-bold text-white bg-green-500 border-2 border-white rounded-full -top-1 -end-1"></div>
            <?php } else { ?>
                <div class="absolute inline-flex items-center justify-center w-4 h-4 text-xs font-bold text-white bg-red-500 border-2 border-white rounded-full -top-2 -end-2 dark:border-gray-900"></div>
            <?php } ?>
        </a>



    </div>

<div class="output">
    <!-- Output will be displayed here -->

</div>
<!-- Main modal -->
<div id="crypto-modal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Choisissez les utilisateurs que vous voulez ajouter
                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm h-8 w-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-toggle="crypto-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-4 md:p-5">
                <p class="text-sm font-normal text-gray-500 dark:text-gray-400">Vous pouvez ajouter plusieurs utilisateurs en même temps</p>
                    <ul>
                        <?php foreach ($users as $user) : ?>
                                <?php include("vue/user.php") ?>
                        <?php endforeach; ?>
                    </ul>
                                
                <div class="flex items-center mt-6 space-x-2 rtl:space-x-reverse">
                    <button data-modal-hide="crypto-modal" type="button" class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">Annuler</button>
                    <button id="add-users" data-modal-hide="crypto-modal" type="button" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Ajouter les utilisateurs</button>
                </div>
            </div>
              <!-- Modal footer -->
   
        </div>
      
    </div>
</div>


<div id="popup-modal" tabindex="-1" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <button type="button" class="absolute top-3 end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="popup-modal">
                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <div class="p-4 md:p-5 text-center">
                <svg class="mx-auto mb-4 text-gray-400 w-12 h-12 dark:text-gray-200" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 11V6m0 8h.01M19 10a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"/>
                </svg>
                <h3 class="mb-5 text-lg font-normal text-gray-500 dark:text-gray-400">Nous allons passer le site en HTTPS. Cela va déconnecter les utilisateurs. Êtes-vous sûr de vouloir continuer ?</h3>
                <p class="mb-5 text-sm text-gray-500 dark:text-gray-400">URL du site : <?php echo get_option('siteurl'); ?></p>
                <button id="switch-to-https" data-modal-hide="popup-modal" type="button" class="text-white bg-red-600 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 dark:focus:ring-red-800 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center me-2">
                    Oui, je suis sûr
                </button>
                <button data-modal-hide="popup-modal" type="button" class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">Non, annuler</button>
            </div>
        </div>
    </div>
</div>
<div id="theme-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Theme enfant
                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm h-8 w-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-toggle="theme-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-4 md:p-5">
            <details class="p-4 rounded-lg bg-gray-50 dark:bg-gray-800" open="">
    <summary class="flex justify-between items-center text-white">Elementor Hello Theme
        <?php
    
        if (is_theme_installed("hello-theme-child-master")) {

            // Check if the plugin is activated 
            if (is_theme_activated("hello-theme-child-master")) {
                echo '<span class="text-green-500 text-right">Installé & Activé</span>';
            } else {
                echo '<span class="text-green-500 text-right">Installé</span>';
            }
        } else {
           echo  '<button data-theme-slug="/hello-theme-child-master.zip" class="install-theme-btn px-4 py-2 text-sm font-medium text-white rounded-lg bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800">Installer et activer</button>';
        }
        ?>
    </summary>
    <div class="output text-white">
    </div>
</details>
            </div>
        </div>
    </div>
</div>



<div id="function-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Désactiver les fonctionnalités unutiles de WordPress
                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm h-8 w-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-toggle="function-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-4 md:p-5">
            <form title="Paramètre des fonctionnalités" method="post" action="options.php">   
            <?php settings_fields('fonctionnalites-settings-group'); ?>
            <label class="relative inline-flex items-center mb-5 cursor-pointer">
                <input type="checkbox" value="1" <?php checked(1, get_option('disable-comments'), true); ?> name="disable-comments" class="sr-only peer">
                <div class="w-11 h-6 bg-gray-600 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-white-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:w-5 after:h-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">Désactiver commentaire</span>
            </label>
            <label class="relative inline-flex items-center mb-5 cursor-pointer">
                <input type="checkbox" value="1" <?php checked(1, get_option('disable-articles'), true); ?> name="disable-articles" class="sr-only peer">
                <div class="w-11 h-6 bg-gray-600 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-white-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:w-5 after:h-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">Désactiver les articles</span>

            </label>
            <button  type="submit" name="submit" id="save-options" data-modal-hide="function-modal" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Enregistrer les modifications</button>
            </form>
        </div>

        </div>
    </div>
</div>

<div id="plugin-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Ajouter des plugins
                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm h-8 w-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-toggle="plugin-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-4 md:p-5">
                <p class="text-sm mb-4 font-normal text-gray-500 dark:text-gray-400">Pour de meilleurs résultats, veuillez patienter entre chaque installation</p>
                <div class="mb-4 border-b border-gray-200 dark:border-gray-700">
                    <ul class="flex flex-wrap -mb-px text-sm font-medium text-center" id="default-tab" data-tabs-toggle="#default-tab-content" role="tablist">
                        <li class="me-2" role="presentation">
                            <button class="inline-block p-4 border-b-2 rounded-t-lg" id="site-vitrine-tab" data-tabs-target="#site-vitrine" type="button" role="tab" aria-controls="site-vitrine" aria-selected="false">Site Vitrine</button>
                        </li>
                        <li class="me-2" role="presentation">
                            <button class="inline-block p-4 border-b-2 rounded-t-lg hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300" id="site-ecommerce-tab" data-tabs-target="#site-ecommerce" type="button" role="tab" aria-controls="site-ecommerce" aria-selected="false">Site E-commerce</button>
                        </li>
                   
                    </ul>
                </div>
                <div id="default-tab-content">
                <div class="hidden flex flex-col gap-4" id="site-vitrine" role="tabpanel" aria-labelledby="site-vitrine-tab">
                        <?php

                            foreach ($pluginArray as $plugin) {
                                include("vue/plugin.php");
                            }


                            ?>

                    </div>
                    <div class="hidden flex flex-col gap-4" id="site-ecommerce" role="tabpanel" aria-labelledby="site-ecommerce-tab">
                    <?php

                        foreach ($pluginArrayWooCommerce as $plugin) {
                            include("vue/plugin.php");
                        }


                        ?>
                    </div>
              
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/2.2.0/flowbite.min.js"></script>