

jQuery('form[action="options.php"]').submit(function(event) {
        event.preventDefault();
        var formData = jQuery(this).serialize();
        var title = jQuery(this).attr('title');
        jQuery.ajax({
            type: 'POST',
            url: jQuery(this).attr('action'), // Posting to options.php
            data: formData,
            success: function(response) {
                alert(title+' sauvegardé !');
            },
            error: function() {
                alert(title+' Bug de sauvegarde');
            }
        });
    });


const install_themes_btns = document.querySelectorAll('.install-theme-btn');

install_themes_btns.forEach(button => {
    button.addEventListener('click', function() {
        // create the nonce using the same method as in the PHP function

        const theme_slug = this.getAttribute('data-theme-slug');

        const originalButtonText = button.innerHTML;
     // Disable the button and show loading state
        button.disabled = true;
        button.innerHTML = 'Installation en cours...';
        jQuery.ajax({
            url: ajaxurl, // 'ajaxurl' is a variable defined by WordPress
            type: 'POST',
            
            data: {
                action: 'install_theme_logia',
                slug: theme_slug,
                nonce: ajaxObject.nonce, 
            },
            success: function(response) {
                const success = response.success;
                const data = response.data;
                const output = button.parentElement.parentElement.querySelector('.output');
                if (success) {
                    output.innerHTML = '<p class="text-green-500">' + data["debug"][data["debug"].length-1] + '</p>';
                    button.innerHTML = 'Installé';
                    button.setAttribute("class", "");
                    button.classList.add("text-green-500", "cursor-normal","pointer-events-none");
                } else {
                    output.innerHTML = '<p class="text-red-500">' + data["debug"][data["debug"].length-1] + '</p>';
                    button.innerHTML = originalButtonText;
                }
            },
            error: function(response) {
                alert('Error during installation');
                button.innerHTML = originalButtonText;
            },
            complete: function() {
                // Enable the button after installation is complete
                button.disabled = false;
            }
        });
    });
});





function installerPlugin(button, pluginSlug, pluginFullSlug,activate,local,local_file_slug) {
    const originalButtonText = button.innerHTML;

    // Disable the button and show loading state
    button.disabled = true;
    button.innerHTML = 'Installation en cours...';
    
    if(activate == 1 && button.parentElement.querySelector("[data-activated='0']")){
        button.parentElement.querySelector("[data-activated='0']").remove();
    } else if (activate == 0 && button.parentElement.querySelector("[data-activated='1']")) {
        button.parentElement.querySelector("[data-activated='1']").remove();
    }

    jQuery.ajax({
        url: ajaxurl, // 'ajaxurl' is a variable defined by WordPress
        type: 'POST',
        data: {
            action: 'installer_plugin',
            plugin_slug: pluginSlug,
            plugin_full_slug: pluginFullSlug,
            local_file_slug : local_file_slug,
            nonce: ajaxObject.nonce, 
            local : local   
        },
        success: function(response) {
            const success = response.success;
            const data = response.data;
            const output = button.parentElement.parentElement.parentElement.querySelector('.output');
            if (success) {
         
                output.innerHTML = '<p class="text-green-500">' + data + '</p>';
                button.innerHTML = 'Installé';


                // remove the button classes and add the text-400
                button.setAttribute("class", "");
                button.classList.add("text-green-500", "cursor-normal","pointer-events-none");
                if (activate == 1) {
                    activerPlugin(button, pluginSlug, pluginFullSlug);
                }

            } else {
                output.innerHTML = '<p class="text-red-500">' + data + '</p>';
                button.innerHTML = originalButtonText;
            }
        },
        error: function(response) {
            alert('Error during installation');
            button.innerHTML = originalButtonText;
        },
        complete: function() {
            // Enable the button after installation is complete
            button.disabled = false;
        }
    });
}

function activerPlugin(button, pluginSlug, pluginFullSlug) {
    const originalButtonText = button.innerHTML;

    // Disable the button and show loading state
    button.disabled = true;
    button.innerHTML = 'Activation en cours...';

    jQuery.ajax({
        url: ajaxurl, // 'ajaxurl' is a variable defined by WordPress
        type: 'POST',
        data: {
            action: 'activate_plugin',
            plugin_slug: pluginSlug,
            plugin_full_slug: pluginFullSlug,
            nonce: ajaxObject.nonce, 
        },
        success: function(response) {
            const success = response.success;
            const data = response.data;
            const output = button.parentElement.parentElement.parentElement.querySelector('.output');
            if (success) {
                output.innerHTML = '<p class="text-green-500">' + data + '</p>';
                button.innerHTML = 'Installé et activé';

                // remove the button classes and add the text-400
                button.setAttribute("class", "");
                button.classList.add("text-green-500");
               button.classList.add("cursor-normal");
                button.classList.add("pointer-events-none");
            } else {
                output.innerHTML = '<p class="text-red-500">' + data + '</p>';
                button.innerHTML = originalButtonText;
            }
        },
        error: function(response) {
            alert('Error during installation');
            button.innerHTML = originalButtonText;
        },
        complete: function() {
            // Enable the button after installation is complete
            button.disabled = false;
        }
    });
}

const buttons = document.querySelectorAll('.install-plugin-btn');

buttons.forEach(button => {
    button.addEventListener('click', function() {
        const pluginSlug = this.getAttribute('data-plugin-slug');
        const activate = this.getAttribute('data-activated');
        const pluginFullSlug = this.getAttribute('data-plugin-full-slug');
        const local = this.getAttribute('data-local');
        const local_file_slug = this.getAttribute('data-local-file-slug');

        installerPlugin(button, pluginSlug, pluginFullSlug,activate,local,local_file_slug);
    });
});



    document.getElementById("add-users").addEventListener("click", function() {
        var users = document.getElementsByName("user-selected");
        var users_selected = [];
        for (var i = 0; i < users.length; i++) {
            if (users[i].checked) {
                users_selected.push(users[i].getAttribute("data-user"));
            }
        }
        var data = {
            action: "create_custom_users",
            users: users_selected,
            nonce: ajaxObject.nonce, 
        };
        jQuery.post(ajaxurl, data, function(response) {
            // Handle response
        });
    });


    // Switch to https
    document.getElementById("switch-to-https").addEventListener("click", function() {
        var data = {
            action: "update_website_url_with_https",
            nonce: ajaxObject.nonce
        };
        jQuery.post(ajaxurl, data, function(response) {
            // Handle response
        });
    });




