<?php
 function disable_features() {
    // disable comments based on option
    if (get_option('disable-comments') == 1) {
        add_action('admin_init', function () {
            // Redirect any user trying to access comments page
            global $pagenow;
             
            if ($pagenow === 'edit-comments.php') {
                wp_safe_redirect(admin_url());
                exit;
            }
         
            // Remove comments metabox from dashboard
            remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
         
            // Disable support for comments and trackbacks in post types
            foreach (get_post_types() as $post_type) {
                if (post_type_supports($post_type, 'comments')) {
                    remove_post_type_support($post_type, 'comments');
                    remove_post_type_support($post_type, 'trackbacks');
                }
            }
        });
         
        // Close comments on the front-end
        add_filter('comments_open', '__return_false', 20, 2);
        add_filter('pings_open', '__return_false', 20, 2);
         
        // Hide existing comments
        add_filter('comments_array', '__return_empty_array', 10, 2);
         
        // Remove comments page in menu
        add_action('admin_menu', function () {
            remove_menu_page('edit-comments.php');
        });
         
        // Remove comments links from admin bar
        add_action('init', function () {
            if (is_admin_bar_showing()) {
                remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60);
            }
        });
    }
    //disable articles 
    if(get_option('disable-articles')){

        if (is_home() || is_category() || is_tag() || is_author() || is_date() || is_search()) {
            wp_redirect(home_url(), 301);
            exit;
        }
    
        // Retirer les menus de blog du tableau de bord
        add_action('admin_menu', function() {
            remove_menu_page('edit.php'); // Posts
        });
    
        // Désactiver le support des posts pour le thème
        add_action('init', function() {
            remove_post_type_support('post', 'all');
        });
    
        // Retirer les widgets liés aux posts
        add_action('widgets_init', function() {
            unregister_widget('WP_Widget_Recent_Posts');
            unregister_widget('WP_Widget_Recent_Comments');
            unregister_widget('WP_Widget_Archives');
            unregister_widget('WP_Widget_Categories');
            unregister_widget('WP_Widget_RSS');
            unregister_widget('WP_Widget_Tag_Cloud');
        });
    
    
    }
    
}
add_action('init','disable_features');
