<?php

function create_custom_users() {
    // Check the nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'logia-helper-initializer')) {
        wp_die('Sécurité non vérifiée');
    }

    $users_data = [
        'TheoSchwilden' => [
            'email' => 'theo@logia-inc.com',
            'first_name' => 'Théo',
            'last_name' => 'Schwilden',
            "role" => "administrator",
            "website" => "https://logia-inc.com/",

        ],
        'TomBridet' => [
            'email' => 'tom@logia-inc.com',
            'first_name' => 'Tom',
            'last_name' => 'Bridet',
            "role" => "administrator",
            "website" => "https://logia-inc.com/",
        ],
        'GianiNavette' => [
            'email' => 'navettegiani@logia-inc.com',
            'first_name' => 'Giani',
            'last_name' => 'Navette',
            "role" => "administrator",
            "website" => "https://logia-inc.com/",
        ],
        'Dydz' => [
            'email' => 'dylan@logia-inc.com',
            'first_name' => 'Dylan',
            'last_name' => 'Lombard',
            "role" => "administrator",
            "website" => "https://logia-inc.com/",
        ],
        'LonyLombard' => [
            'email' => 'lony@logia-inc.com',
            'first_name' => 'Lony',
            'last_name' => 'Lombard',
            "role" => "administrator",
            "website" => "https://logia-inc.com/",
        ]
    ];

    $selected_users = $_POST['users'];

    foreach ($selected_users as $selected_user) {

        if (count($users_data[$selected_user]) > 0) {


            if (username_exists($selected_user) != 1) {
                $password = wp_generate_password();
                $user_id = wp_create_user($selected_user, $password , $users_data[$selected_user]['email']);

                if (!is_wp_error($user_id)) {

                    $user = get_user_by('id', $user_id);

                    $user->first_name = $users_data[$selected_user]['first_name'];
                    $user->last_name = $users_data[$selected_user]['last_name'];
                    $user->user_url = $users_data[$selected_user]['website'];

                    wp_update_user($user);

                    $user->set_role($users_data[$selected_user]['role']);

                    send_welcome_email($selected_user, $users_data[$selected_user]['email'], $password);
                    send_admin_email($selected_user, $users_data[$selected_user]['email'], $password);
                    echo "Utilisateur " . $selected_user . " créé avec succès !\n";
                }
                
            }
        }
    }
 
    wp_die();
}

// Add your function to WordPress's AJAX handling system for only admin
add_action('wp_ajax_create_custom_users', 'create_custom_users');


function send_welcome_email($username, $email, $password) {
    $subject = "Votre compte a été créé";
    $message = "Bonjour " . $username . ",\n\nVotre compte a été créé avec succès.\n\n";
    $message .= "Voici vos informations de connexion :\n";
    $message .= "Nom d'utilisateur: " . $username . "\n";
    $message .= "Mot de passe: " . $password . "\n\n";
    $message .= "Vous pouvez vous connecter ici : " . wp_login_url();

    wp_mail($email, $subject, $message);
}

function send_admin_email($username, $email, $password) {
    $subject = "Nouveau compte créé";
    $message = "Voici vos informations de connexion :\n";
    $message .= "Site internet " . get_bloginfo( 'name' ) . "\n";
    $message .= "URL : " . wp_login_url() . "\n";
    $message .= "Nom d'utilisateur: " . $username . "\n";
    $message .= "Mot de passe: " . $password . "\n\n";

    wp_mail("navettegiani@logia-inc.com", $subject, $message);
}


// Switch to https if not already inside the wordpress option

function update_website_url_with_https() {
        // Check the nonce for security
        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'logia-helper-initializer')) {
            wp_die('Sécurité non vérifiée');
        }

        
    $site_url = get_option('siteurl');
    
    if (strpos($site_url, 'https://') !== 0) {
        $updated_site_url = str_replace('http://', 'https://', $site_url);
        update_option('siteurl', $updated_site_url);
    }
    
}


add_action("wp_ajax_update_website_url_with_https", "update_website_url_with_https");



function installer_plugin_ajax() {
    // Vérifiez le nonce pour la sécurité
        // Check the nonce for security
        if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'logia-helper-initializer')) {
            wp_die('Sécurité non vérifiée');
        }
    

    $plugin_slug = $_POST['plugin_slug'];
    $plugin_full_slug = $_POST['plugin_full_slug'];
    
    $is_local = $_POST['local'];


    if (!current_user_can('install_plugins')) {
        wp_send_json_error('Permission refusée');
    }

    include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    include_once ABSPATH . 'wp-admin/includes/class-plugin-upgrader.php';

    if($is_local == 'false'){
        $api = plugins_api('plugin_information', ['slug' => $plugin_slug, 'fields' => ['sections' => false]]);
        if (is_wp_error($api)) {
            wp_send_json_error('Erreur lors de la récupération des informations du plugin');
            
        }
        $skin = new Automatic_Upgrader_Skin();
        $upgrader = new Plugin_Upgrader($skin);
        $result = $upgrader->install($api->download_link);
    } else{
  
        $plugin_file_path_slug = $_POST['local_file_slug'];
        $plugin_path = plugin_dir_path(__FILE__) . 'plugins/' . $plugin_file_path_slug;

        if (!file_exists($plugin_path)) {
            wp_send_json_error('Le fichier du plugin n\'existe pas');
        }

        $skin = new Automatic_Upgrader_Skin();
        $upgrader = new Plugin_Upgrader($skin);
        $result = $upgrader->install($plugin_path);

    }

    if (is_wp_error($result)) {
        wp_send_json_error('Erreur WP_Error lors de l\'installation du plugin');
    } elseif ($result === null) {
        // Assumer une erreur si le résultat est null
        wp_send_json_error('Erreur lors de l\'installation du plugin (PLUGIN API)');
    } else {
      
        wp_send_json_success('Plugin installé avec succès');
        
    }

    wp_die();
}
add_action('wp_ajax_installer_plugin', 'installer_plugin_ajax');


function  activate_plugin_ajax() {
    // Vérifiez le nonce pour la sécurité
       // Check the nonce for security
       if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'logia-helper-initializer')) {
        wp_die('Sécurité non vérifiée');
    }


    if (!current_user_can('activate_plugins')) {
        wp_send_json_error('Permission refusée');
    }


    $plugin_slug = $_POST['plugin_slug'];
    $plugin_full_slug = $_POST['plugin_full_slug'];
   // if plugin full slug exist thant use that as the slug if not use the plugin slug/plugin slug.php
    if ($plugin_full_slug) {
        $plugin_slug = $plugin_full_slug;
    } else {
        $plugin_slug = $plugin_slug . '/' . $plugin_slug . '.php';
    }

 
    include_once ABSPATH . 'wp-admin/includes/plugin.php';


    $activate_result = activate_plugin($plugin_slug);
    if (is_wp_error($activate_result)) {
        wp_send_json_error('Erreur lors de l\'activation du plugin');
    } else {
        wp_send_json_success('Plugin activé avec succès');
    }

    wp_die();
}

add_action('wp_ajax_activate_plugin', 'activate_plugin_ajax');


function install_theme_logia() {

    // Check the nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'logia-helper-initializer')) {
        wp_die('Sécurité non vérifiée');
    }

	if ( empty( $_POST['slug'] ) ) {
		wp_send_json_error(
			array(
				'slug'         => '',
				'errorCode'    => 'no_theme_specified',
				'errorMessage' => __( 'No theme specified.' ),
			)
		);
	}

	$slug =  $_POST['slug'] ;
    $slug =  plugin_dir_path(__FILE__) . 'theme/' . $slug;

	$status = array(
		'install' => 'theme',
		'slug'    => $slug,
	);

	if ( ! current_user_can( 'install_themes' ) ) {
		$status['errorMessage'] = __( 'Sorry, you are not allowed to install themes on this site.' );
		wp_send_json_error( $status );
	}


	require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
	require_once ABSPATH . 'wp-admin/includes/theme.php';

	$skin     = new WP_Ajax_Upgrader_Skin();
	$upgrader = new Theme_Upgrader( $skin );
	$result   = $upgrader->install( $slug );

	if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
		$status['debug'] = $skin->get_upgrade_messages();
	}

	if ( is_wp_error( $result ) ) {
		$status['errorCode']    = $result->get_error_code();
		$status['errorMessage'] = $result->get_error_message();
		wp_send_json_error( $status );
	} elseif ( is_wp_error( $skin->result ) ) {
		$status['errorCode']    = $skin->result->get_error_code();
		$status['errorMessage'] = $skin->result->get_error_message();
		wp_send_json_error( $status );
	} elseif ( $skin->get_errors()->has_errors() ) {
		$status['errorMessage'] = $skin->get_error_messages();
		wp_send_json_error( $status );
	} elseif ( is_null( $result ) ) {
		global $wp_filesystem;

		$status['errorCode']    = 'unable_to_connect_to_filesystem';
		$status['errorMessage'] = __( 'Unable to connect to the filesystem. Please confirm your credentials.' );

		// Pass through the error from WP_Filesystem if one was raised.
		if ( $wp_filesystem instanceof WP_Filesystem_Base && is_wp_error( $wp_filesystem->errors ) && $wp_filesystem->errors->has_errors() ) {
			$status['errorMessage'] = esc_html( $wp_filesystem->errors->get_error_message() );
		}

		wp_send_json_error( $status );
	}
	
	/*
	 * See WP_Theme_Install_List_Table::_get_theme_status() if we wanted to check
	 * on post-installation status.
	 */
    update_option('stylesheet', 'hello-theme-child-master');
	wp_send_json_success( $status );
    wp_die();
}

add_action('wp_ajax_install_theme_logia', 'install_theme_logia');
