<?php
//add_filter("the_content", "tct_template_tags_content");
function tct_template_tags_content($content){
    $prefixes = ["fn", "theme", "field", "user", "userm", "author","post","option"];
    $pattern = "/\\[\\[(" . implode("|", $prefixes) . ")\.([\w-]+)\\]\\]/";

    $new_content = preg_replace_callback($pattern, function ($matches) {
        $dynamic_tag = trim($matches[2]);

        switch ($matches[1]) {
            case "fn":
                if (!function_exists($dynamic_tag)) {
                    return;
                }
                return call_user_func($dynamic_tag);
            case "query": // Query param
                return isset($_GET[$dynamic_tag])
                    ? sanitize_text_field($_GET[$dynamic_tag])
                    : "";
            case "theme": // Options page
                if (!function_exists("get_field")) break;
                return get_field($dynamic_tag, "options");
            case "field": // ACF Field
                if (!function_exists("get_field")) break;
                return get_field($dynamic_tag);
            case "user": // Supported user info https://tct.so/User-info
                $current_user = wp_get_current_user();
                return $current_user->$dynamic_tag;
            case "userm": // User meta
                $user_id = get_current_user_id();
                return get_user_meta($user_id, $dynamic_tag, true);
            case "author": // Supported author info https://tct.so/author-values
                return get_the_author_meta($dynamic_tag);
			case "post": // Post object properties
                global $post; // Ensure global post object is available
                if(isset($post->$dynamic_tag)) {
                    return $post->$dynamic_tag;
                }
                break;
			case "option":
				return get_option($dynamic_tag);
				break;
			default:
				return $matches[0];
				break;
        }

        // Otherwise, return the original text
        return $matches[0];
    }, $content);

    return $new_content;
}

function v_shortcode($atts, $content = "") {
    // No attributes are needed since the content is directly passed
    $tag_content = "[[{$content}]]"; // Format the content as if it was a template tag
    return tct_template_tags_content($tag_content); // Reuse your existing function
}
add_shortcode('g', 'v_shortcode');

// TODO add array values with a third . this point will be able to go through an array
// TODO add a way to format the query with emmet for example the div.class or article.div
// TODO add array:name but the function loops over array but queries the value name each time