<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Form Field - Local Tel
 *
 * Add a new "Local Tel" field to Elementor form widget.
 *
 * @since 1.0.0
 */
class Elementor_captcha_mandatory_field extends \ElementorPro\Modules\Forms\Fields\Field_Base {

	/**
	 * Get field type.
	 *
	 * Retrieve local-tel field unique ID.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Field type.
	 */
	public function get_type() {
		return 'captcha-mandatory';
	}

	/**
	 * Get field name.
	 *
	 * Retrieve local-tel field label.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Field name.
	 */
	public function get_name() {
		return esc_html__( 'Confirmation de Captcha invisible', 'logia-helper' );
	}

	/**
	 * Render field output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param mixed $item
	 * @param mixed $item_index
	 * @param mixed $form
	 * @return void
	 */
	public function render( $item, $item_index, $form ) {
		echo '<p class="texte-captcha">
        Ce site est protégé par reCAPTCHA et les règles de
        <a href="https://policies.google.com/privacy">Politique de confidentialité</a> et
        <a href="https://policies.google.com/terms">Conditions d\'utilisation</a> de Google s\'appliquent.</p>
        <style>
        .grecaptcha-badge { 
            visibility: hidden;
        }
        </style>
        ';
	}
/**
	 * Field constructor.
	 *
	 * Used to add a script to the Elementor editor preview.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return void
	 */
	public function __construct() {
		parent::__construct();
		add_action( 'elementor/preview/init', [ $this, 'editor_preview_footer' ] );
	}
	/**
	 * Elementor editor preview.
	 *
	 * Add a script to the footer of the editor preview screen.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return void
	 */
	public function editor_preview_footer() {
		add_action( 'wp_footer', [ $this, 'content_template_script' ] );
	}


    /**
	 * Content template script.
	 *
	 * Add content template alternative, to display the field in Elemntor editor.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return void
	 */
	public function content_template_script() {
		?>
		<script>
		jQuery( document ).ready( () => {

			elementor.hooks.addFilter(
				'elementor_pro/forms/content_template/field/<?php echo $this->get_type(); ?>',
				function ( inputField, item, i ) {


                    return '<p>Ce site est protégé par reCAPTCHA et les règles de <a href="https://policies.google.com/privacy">Politique de confidentialité</a> et <a href="https://policies.google.com/terms">Conditions d\'utilisation</a> de Google s\'appliquent.</p>';
					
				}, 10, 3
			);

		});
		</script>
		<?php
	}

}


