<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Form Field - Local Tel
 *
 * Add a new "Local Tel" field to Elementor form widget.
 *
 * @since 1.0.0
 */
class Elementor_action_field_custom_javascript extends \ElementorPro\Modules\Forms\Fields\Field_Base {

	/**
	 * Get field type.
	 *
	 * Retrieve local-tel field unique ID.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Field type.
	 */
	public function get_type() {
		return 'custom-javascript';
	}

	/**
	 * Get field name.
	 *
	 * Retrieve local-tel field label.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Field name.
	 */
	public function get_name() {
		return esc_html__( 'Javascript personnalisée (Action)', 'logia-helper' );
	}

	/**
	 * Render field output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param mixed $item
	 * @param mixed $item_index
	 * @param mixed $form
	 * @return void
	 */
	public function render( $item, $item_index, $form ) {
        $form_id = $form->get_id();
		echo '<script>
        jQuery(document).ready(function($) {
            $(document).on(\'submit_success\', function(event, response) {
                if (response.data.custom_javascript && response.data.form_id) {
                    // Get the form ID
                    const formId = response.data.form_id;
        
                    // Now you can check if this is the form you want to target
                    // For example:
                    if (formId === \''.$form_id.'\') {
                        try {
                            // Execute the custom JavaScript
                            eval(response.data.custom_javascript);
                        } catch (error) {
                            console.error(\'Error executing custom JavaScript:\', error);
                        }
                    }
                }
            });
        });
        </script>
        ';
	}


}


