jQuery(window).on('elementor:init', function() {

    elementor.hooks.addAction( 'panel/open_editor/widget/form', ( panel, model ) => {
       
        checkIfRecaptchaV3Exists( model,panel );

        const settingsModel = model.get( 'settings' ).get('form_fields');

        settingsModel.on( 'add', ( changedModel,panel ) => {
            checkIfRecaptchaV3Exists( model,panel );


        } );
        settingsModel.on( 'remove', ( changedModel ) => {
            checkIfRecaptchaV3Exists( model,panel );

        } );
        settingsModel.on( 'change', ( changedModel ) => {
            checkIfRecaptchaV3Exists( model,panel );

        } );

   
    } );

});

function checkIfRecaptchaV3Exists( model,panel ) {
    const formFields = model.get('settings').get('form_fields');
    const hasRecaptchaV3 = formFields.some( field => field.get('field_type') === 'recaptcha_v3' );
    const hasRecaptcha = formFields.some( field => field.get('field_type') === 'recaptcha' );
    const hasCaptchaMandatory = formFields.some( field => field.get('field_type') === 'captcha-mandatory' );
    let message = '';

    if ( hasRecaptchaV3 && hasCaptchaMandatory ) {
        message = 'Parfait ! Le formulaire est bien sécurisé avec reCAPTCHA v3 et la vérification obligatoire.';
        textColor = 'green';
    } else if ( hasRecaptchaV3 ) {
        message = 'Presque terminé ! Veuillez ajouter la vérification de captcha obligatoire pour renforcer la sécurité.';
        textColor = 'orange';
    } else if ( hasRecaptcha ) {
        message = 'Bien, mais envisagez de passer à reCAPTCHA v3 pour une sécurité et une expérience utilisateur améliorées.';
        textColor = 'blue';
    } else {
        message = 'Veuillez ne pas oublier d’ajouter un captcha pour sécuriser votre formulaire.';
        textColor = 'red';
    }
    var $messageDiv = jQuery('<div/>', {
        class: 'elementor-control elementor-recaptcha-reminder',
        text: message,
        css: {
            color: textColor,
            fontWeight: 'bold',
            marginBottom: '10px'
        }
    });
    // Remove any existing reminders before adding a new one
    jQuery(panel.$el).find('.elementor-recaptcha-reminder').remove();
    
    var $formFieldsControl = jQuery(panel.$el).find('.elementor-control-form_fields');

    // Check if the reminder message has already been added to prevent duplicates
 
    $formFieldsControl.before($messageDiv);
    
}



