<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor form JavaScript action.
 *
 * Custom Elementor form action which will execute custom JavaScript code after form submission.
 *
 * @since 1.0.0
 */
class Javascript_After_Submit extends \ElementorPro\Modules\Forms\Classes\Action_Base {

	/**
	 * Get action name.
	 *
	 * Retrieve JavaScript action name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string
	 */
	public function get_name() {
		return 'javascript';
	}

	/**
	 * Get action label.
	 *
	 * Retrieve JavaScript action label.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string
	 */
	public function get_label() {
		return esc_html__( 'Javascript', 'logia-helper' );
	}

	/**
	 * Run action.
	 *
	 * Execute custom JavaScript code after form submission.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param \ElementorPro\Modules\Forms\Classes\Form_Record  $record
	 * @param \ElementorPro\Modules\Forms\Classes\Ajax_Handler $ajax_handler
	 */
	public function run( $record, $ajax_handler ) {

		$settings = $record->get('form_settings');
		if ( !empty($settings['custom_javascript']) ) {
			$custom_js = $settings['custom_javascript'];
			// Assuming you can get the form ID like this; adjust if needed
			$form_id = $record->get_form_settings('id');
	
			// Pass the custom JavaScript and form ID to the front end
			$ajax_handler->add_response_data('custom_javascript', $custom_js);
			$ajax_handler->add_response_data('form_id', $form_id);
		}

	}

	/**
	 * Register action controls.
	 *
	 * JavaScript action has a control for entering custom JavaScript code.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param \Elementor\Widget_Base $widget
	 */
	public function register_settings_section( $widget ) {

		$widget->start_controls_section(
			'section_javascript',
			[
				'label' => esc_html__( 'JavaScript Personnalisé', 'logia-helper' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'submit_actions' => 'javascript',
				],
			]
		);
	
		$widget->add_control(
			'custom_javascript',
			[
				'label' => esc_html__( 'JavaScript Personnalisé', 'logia-helper' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'javascript',
				'rows' => 20,
				'description' => esc_html__( 'Saisissez ici votre code JavaScript personnalisé. Il sera exécuté après la transmission du formulaire.', 'logia-helper' ),
				'condition' => [
					'submit_actions' => 'javascript',
				],
			
				]
		);
	
		$widget->end_controls_section();
	}
	

	/**
	 * On export.
	 *
	 * JavaScript action has no fields to clear when exporting.
	 *
	 * @since 1.0.0
	 * @access public
	 * @param array $element
	 */
	public function on_export( $element ) {}

}
