<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
/**
 * Elementor Dynamic Tag - Random Number
 *
 * Elementor dynamic tag that returns a random number.
 *
 * @since 1.0.0
 */
class Elementor_Dynamic_Tag_Facebook_URL extends \Elementor\Core\DynamicTags\Tag
{

    /**
     * Get dynamic tag name.
     *
     * Retrieve the name of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag name.
     */
    public function get_name()
    {
        return 'Facebook-URL';
    }

    /**
     * Get dynamic tag title.
     *
     * Returns the title of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag title.
     */
    public function get_title()
    {
        return esc_html__('Facebook URL', 'logia-helper');
    }

    /**
     * Get dynamic tag groups.
     *
     * Retrieve the list of groups the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag groups.
     */
    public function get_group()
    {
        return ['Logia'];
    }

    /**
     * Get dynamic tag categories.
     *
     * Retrieve the list of categories the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag categories.
     */
    public function get_categories()
    {
        return [\Elementor\Modules\DynamicTags\Module::URL_CATEGORY];
    }

    /**
     * Render tag output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access public
     * @return void
     */
    public function render()
    {
        if (get_option('logia-dynamic-tag-facebook') == false || get_option('logia-dynamic-tag-facebook') == "") {
            echo 'https://www.facebook.com/';
        } else {
            echo get_option('logia-dynamic-tag-facebook');
        }
    }
}



/**
 * Elementor Dynamic Tag - Random Number
 *
 * Elementor dynamic tag that returns a random number.
 *
 * @since 1.0.0
 */
class Elementor_Dynamic_Tag_Instagram_URL extends \Elementor\Core\DynamicTags\Tag
{

    /**
     * Get dynamic tag name.
     *
     * Retrieve the name of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag name.
     */
    public function get_name()
    {
        return 'Instagram-URL';
    }

    /**
     * Get dynamic tag title.
     *
     * Returns the title of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag title.
     */
    public function get_title()
    {
        return esc_html__('Instagram URL', 'logia-helper');
    }

    /**
     * Get dynamic tag groups.
     *
     * Retrieve the list of groups the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag groups.
     */
    public function get_group()
    {
        return ['Logia'];
    }

    /**
     * Get dynamic tag categories.
     *
     * Retrieve the list of categories the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag categories.
     */
    public function get_categories()
    {
        return [\Elementor\Modules\DynamicTags\Module::URL_CATEGORY];
    }

    /**
     * Render tag output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access public
     * @return void
     */
    public function render()
    {
        if (get_option('logia-dynamic-tag-instagram') == false || get_option('logia-dynamic-tag-instagram') == "") {
            echo 'https://www.Instagram.com/';
        } else {
            echo get_option('logia-dynamic-tag-instagram');
        }
    }
}


/**
 * Elementor Dynamic Tag - Random Number
 *
 * Elementor dynamic tag that returns a random number.
 *
 * @since 1.0.0
 */
class Elementor_Dynamic_Tag_Youtube_URL extends \Elementor\Core\DynamicTags\Tag
{

    /**
     * Get dynamic tag name.
     *
     * Retrieve the name of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag name.
     */
    public function get_name()
    {
        return 'Youtube-URL';
    }

    /**
     * Get dynamic tag title.
     *
     * Returns the title of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag title.
     */
    public function get_title()
    {
        return esc_html__('Youtube URL', 'logia-helper');
    }

    /**
     * Get dynamic tag groups.
     *
     * Retrieve the list of groups the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag groups.
     */
    public function get_group()
    {
        return ['Logia'];
    }

    /**
     * Get dynamic tag categories.
     *
     * Retrieve the list of categories the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag categories.
     */
    public function get_categories()
    {
        return [\Elementor\Modules\DynamicTags\Module::URL_CATEGORY];
    }

    /**
     * Render tag output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access public
     * @return void
     */
    public function render()
    {
        if (get_option('logia-dynamic-tag-youtube') == false || get_option('logia-dynamic-tag-youtube') == "") {
            echo 'https://www.Youtube.com/';
        } else {
            echo get_option('logia-dynamic-tag-youtube');
        }
    }
}


/**
 * Elementor Dynamic Tag - Random Number
 *
 * Elementor dynamic tag that returns a random number.
 *
 * @since 1.0.0
 */
class Elementor_Dynamic_Tag_Linkedin_URL extends \Elementor\Core\DynamicTags\Tag
{

    /**
     * Get dynamic tag name.
     *
     * Retrieve the name of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag name.
     */
    public function get_name()
    {
        return 'Linkedin-URL';
    }

    /**
     * Get dynamic tag title.
     *
     * Returns the title of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag title.
     */
    public function get_title()
    {
        return esc_html__('Linkedin URL', 'logia-helper');
    }

    /**
     * Get dynamic tag groups.
     *
     * Retrieve the list of groups the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag groups.
     */
    public function get_group()
    {
        return ['Logia'];
    }

    /**
     * Get dynamic tag categories.
     *
     * Retrieve the list of categories the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag categories.
     */
    public function get_categories()
    {
        return [\Elementor\Modules\DynamicTags\Module::URL_CATEGORY];
    }

    /**
     * Render tag output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access public
     * @return void
     */
    public function render()
    {
        if (get_option('logia-dynamic-tag-linkedin') == false || get_option('logia-dynamic-tag-linkedin') == "") {
            echo 'https://www.linkedin.com/';
        } else {
            echo get_option('logia-dynamic-tag-linkedin');
        }
    }
}
