<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Elementor Dynamic Tag - Random Number
 *
 * Elementor dynamic tag that returns a random number.
 *
 * @since 1.0.0
 */
class Elementor_Dynamic_Tag_Address extends \Elementor\Core\DynamicTags\Tag
{

    /**
     * Get dynamic tag name.
     *
     * Retrieve the name of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag name.
     */
    public function get_name()
    {
        return 'Address';
    }

    /**
     * Get dynamic tag title.
     *
     * Returns the title of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag title.
     */
    public function get_title()
    {
        return esc_html__('Adresse', 'logia-helper');
    }

    /**
     * Get dynamic tag groups.
     *
     * Retrieve the list of groups the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag groups.
     */
    public function get_group()
    {
        return ['Logia'];
    }

    /**
     * Get dynamic tag categories.
     *
     * Retrieve the list of categories the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag categories.
     */
    public function get_categories()
    {
        return [\Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY];
    }

    /**
     * Render tag output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access public
     * @return void
     */
    public function render()
    {

        if (get_option('logia-dynamic-tag-address') == false || get_option('logia-dynamic-tag-address') == "") {
            echo "Aucune adresse défini. Veuillez le définir dans les paramètres de Logia Helper";
        } else {
            echo get_option('logia-dynamic-tag-address');
        }
    }
}



/**
 * Elementor Dynamic Tag - Random Number
 *
 * Elementor dynamic tag that returns a random number.
 *
 * @since 1.0.0
 */
class Elementor_Dynamic_Tag_Address_URL extends \Elementor\Core\DynamicTags\Tag
{

    /**
     * Get dynamic tag name.
     *
     * Retrieve the name of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag name.
     */
    public function get_name()
    {
        return 'Address-URL';
    }

    /**
     * Get dynamic tag title.
     *
     * Returns the title of the random number tag.
     *
     * @since 1.0.0
     * @access public
     * @return string Dynamic tag title.
     */
    public function get_title()
    {
        return esc_html__('Adresse URL', 'logia-helper');
    }

    /**
     * Get dynamic tag groups.
     *
     * Retrieve the list of groups the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag groups.
     */
    public function get_group()
    {
        return ['Logia'];
    }

    /**
     * Get dynamic tag categories.
     *
     * Retrieve the list of categories the random number tag belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Dynamic tag categories.
     */
    public function get_categories()
    {
        return [\Elementor\Modules\DynamicTags\Module::URL_CATEGORY];
    }

    /**
     * Render tag output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access public
     * @return void
     */
    public function render()
    {
        if (get_option('logia-dynamic-tag-address') == false || get_option('logia-dynamic-tag-address') == "") {
            echo "Aucune adresse défini. Veuillez le définir dans les paramètres de Logia Helper";
        } else {
            echo "http://maps.apple.com/?q=" . get_option('logia-dynamic-tag-address');
        }
    }
}
