<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>


<h2>Paramètres du menu Contextuel</h2>
<form title="Paramètre du menu contextuel" method="post" action="options.php">
    <?php settings_fields('custom-context-menu'); ?>
    <?php do_settings_sections('custom-context-menu'); ?>
    <table class="form-table">
    <tr>
            <th scope="row"><label for="context_menu_enabled">Enable Context Menu</label></th>
                <td>
                    <input type="checkbox" name="context_menu_enabled" value="1" <?php checked(get_option('context_menu_enabled'), 1); ?> />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Couleur du texte du contexte menu</th>
                <td>
                    <input type="color" name="context_menu_text_color" value="<?php echo esc_attr(get_option('context_menu_text_color')); ?>" />
                </td>
            </tr>
            <tr>
                <th scope="row">Couleur du texte du contexte menu au survol</th>
                <td>
                    <input type="color" name="context_menu_hover_color" value="<?php echo esc_attr(get_option('context_menu_hover_color')); ?>" />
                </td>
            </tr>



            <tr valign="top">
                <th scope="row">Couleur du fond du contexte menu (par defaut blanc)</th>
                <td>
                  <input type="color" name="context_menu_background_color" value="<?php echo esc_attr(get_option('context_menu_background_color')); ?>" />
                </td>
            </tr>


            <tr>

                <th scope="row"><label for="custom_cta_button">Bouton personnalisée</label></th>
                <td>
                    <input type="checkbox" name="custom_cta_button" value="1" <?php checked(get_option('custom_cta_button'), 1); ?> />
                </td>
              
            </tr>
            <tr>

            
                    <th scope="row"><label for="cta_button_text">Texte du bouton</label></th>
                    <td>
                    <input type="text" name="cta_button_text" value="<?php echo esc_attr(get_option('cta_button_text')); ?>" class="regular-text" />
                </td>
                
            </tr>

            <tr>
            <th scope="row"><label for="cta_button_text">URL du bouton</label></th>
            <td>
                    <input  type="text" name="cta_button_url" value="<?php echo esc_attr(get_option('cta_button_url')); ?>" class="regular-text" />
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="twitter_url">Twitter URL</label></th>
                <td>
                    <input type="url" name="twitter_url" value="<?php echo esc_attr(get_option('twitter_url')); ?>" class="regular-text" />
                </td>
            </tr>

            <tr>
                <th scope="row"><label for="facebook_url">Facebook URL</label></th>
                <td>
                    <input type="url" name="facebook_url" value="<?php echo esc_attr(get_option('facebook_url')); ?>" class="regular-text" />
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="instagram_url">Instagram URL</label></th>
                <td>
                    <input type="url" name="instagram_url" value="<?php echo esc_attr(get_option('instagram_url')); ?>" class="regular-text" />
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="linkedin_url">LinkedIn URL</label></th>
                <td>
                    <input type="url" name="linkedin_url" value="<?php echo esc_attr(get_option('linkedin_url')); ?>" class="regular-text" />
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="youtube_url">YouTube URL</label></th>
                <td>
                    <input type="url" name="youtube_url" value="<?php echo esc_attr(get_option('youtube_url')); ?>" class="regular-text" />
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="email_address">Email Address</label></th>
                <td>
                    <input type="email" name="email_address" value="<?php echo esc_attr(get_option('email_address')); ?>" class="regular-text" />
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="phone_number">Phone Number</label></th>
                <td>
                    <input type="text" name="phone_number" value="<?php echo esc_attr(get_option('phone_number')); ?>" class="regular-text" />
                </td>
            </tr>

    </table>
    <?php submit_button(); ?>
</form>
