<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


function render_context_menu()
    {

        if (get_option('context_menu_enabled')) {

            $social_links = get_social_links();
            $contact_info = get_contact_info();
            ob_start();
            echo '<div id="contextMenu"><div class="contextMenu">';
            echo render_home_link();
            if(get_option("custom_cta_button")){
                echo '<a href="'. get_option("cta_button_url") .'">'. get_option("cta_button_text") .'</a>';
            }
            echo $contact_info;
            echo $social_links;
            echo '</div></div>';
            echo '<style>
            :root {
                --context-menu-text-color: ' . get_option('context_menu_text_color') . ';
                --context-menu-background-color: ' . get_option('context_menu_background_color') . ';
                --context-menu-hover-color: ' . get_option('context_menu_hover_color') . ';
            }
            </style>';
             ob_end_flush();  
        }

    }

    add_action('wp_footer', 'render_context_menu');

    function render_home_link()
    {
        return '<a href="/">    <svg xmlns="http://www.w3.org/2000/svg" id="Outline" viewBox="0 0 24 24" width="512" height="512">
    <path
        d="M23.121,9.069,15.536,1.483a5.008,5.008,0,0,0-7.072,0L.879,9.069A2.978,2.978,0,0,0,0,11.19v9.817a3,3,0,0,0,3,3H21a3,3,0,0,0,3-3V11.19A2.978,2.978,0,0,0,23.121,9.069ZM15,22.007H9V18.073a3,3,0,0,1,6,0Zm7-1a1,1,0,0,1-1,1H17V18.073a5,5,0,0,0-10,0v3.934H3a1,1,0,0,1-1-1V11.19a1.008,1.008,0,0,1,.293-.707L9.878,2.9a3.008,3.008,0,0,1,4.244,0l7.585,7.586A1.008,1.008,0,0,1,22,11.19Z" />
</svg>Accueil</a>';
    }

    function get_contact_info()
    {
        $email_address = sanitize_email(get_option('email_address'));
        $phone_number = esc_html(get_option('phone_number'));
        $contact_info = '<div class="contact-info">';

        if ($email_address) {
            $contact_info .= '<a href="mailto:' . $email_address . '">'. renderIcon("email.svg") . 'Email</a>';
        }

        if ($phone_number) {
            $contact_info .= '<a href="tel:' . $phone_number . '">'. renderIcon("phone.svg") . 'Téléphone</a>';
        }

        $contact_info .= '</div>';
        return $contact_info;
    }

    function get_social_links()
    {
        $social_links = '';
        $social_platforms = [
            'facebook_url' => [
                'url' => esc_url(get_option('facebook_url')),
                'icon' => 'facebook.svg',
                'text' => 'Facebook',
            ],
            'instagram_url' => [
                'url' => esc_url(get_option('instagram_url')),
                'icon' => 'instagram.svg',
                'text' => 'Instagram',
            ],
            'linkedin_url' => [
                'url' => esc_url(get_option('linkedin_url')),
                'icon' => 'linkedin.svg',
                'text' => 'LinkedIn',
            ],
            'youtube_url' => [
                'url' => esc_url(get_option('youtube_url')),
                'icon' => 'youtube.svg',
                'text' => 'YouTube',
            ]
        ];

        foreach ($social_platforms as $platform) {
            if ($platform['url']) {
                $platform['icon'] = $platform['icon'] ? renderIcon($platform['icon']) : '';
                $social_links .= sprintf(
                    '<a href="%s" target="_blank">%s%s</a>',
                    $platform['url'],
                    $platform['icon'],
                    $platform['text']
                );
            }
        }

        if ($social_links) {
            return '<div class="social">' . $social_links . '</div>';
        }

        return '';
    }

    function renderIcon($iconPath){
        $iconFile = plugin_dir_path(__FILE__) . 'assets/' . $iconPath;
        if (file_exists($iconFile)) {
            $iconContents = file_get_contents($iconFile);
            return $iconContents;
        }
        return '';
    }
