const rightClickableArea = document.querySelector('body');
const template = document.getElementById('contextMenu');
const instance = tippy(rightClickableArea, {
    content: template,
    appendTo : document.body,
    theme: "contextMenu",
    placement: 'right-start',
    trigger: 'manual',
    interactive: true,
    maxWidth: 450,
    arrow: false,
    offset: [0, 0],
});

rightClickableArea.addEventListener('contextmenu', (event) => {
    const selectedText = window.getSelection().toString();
    
    // Si du texte est sélectionné, on ignore le menu contextuel personnalisé
    if (selectedText.length > 0) {
        return;
    }
    
    // Si l'élément sur lequel on a cliqué est un lien ou un enfant d'un lien, on ignore le menu contextuel personnalisé
    if (event.target.closest('a')) {
        return;
    }
	
	 // Si l'élément sur lequel on a cliqué est un lien ou un enfant d'un lien, on ignore le menu contextuel personnalisé
    if (event.target.closest('img')) {
        return;
    }

    event.preventDefault();

    instance.setProps({
        getReferenceClientRect: () => ({
            width: 0,
            height: 0,
            top: event.clientY,
            bottom: event.clientY,
            left: event.clientX,
            right: event.clientX,
        }),
    });

    instance.show();
});


rightClickableArea.addEventListener('click', (event) => {
    if (event.button === 0) {
        instance.hide();
    }
});