<?php
    $arrayTemplates = array(
        array(
            "id" => "template1",
            "image" => plugins_url("/templates-import/template1/Capture d'écran 2024-05-06 115236.png", __FILE__),
            "type" => "header",
            "name" => "Template 1",
            "description" => "Template 1 description",
            "button" => "Importer"
        ),
        array(
            "id" => "template2",
            "image" => plugins_url("", __FILE__),
            "type" => "footer",
            "name" => "Template 2",
            "description" => "Template 2 description",
            "button" => "Importer"
        ),
        
    );

?>


<div class="wrap">
    <button id="importUIPress" class="button button-primary">Importer les réglages de UIPress</button>
    <!-- <h2>Templates</h2>
    <div class="templates">
        <?php foreach ($arrayTemplates as $template) : ?>
            <div class="template">
                <span class="badge"><?= $template['type'] ?></span>
                <img src="<?= $template['image'] ?>" alt="<?= $template['name'] ?>">
                <h4><?= $template['name'] ?></h4>
                <p><?= $template['description'] ?></p>
                <button class="button button-primary"><?= $template['button'] ?></button>
            </div>
        <?php endforeach; ?>
    </div>
     -->
    <h2>Paramètres des variables global</h2>


    <form title="Variable Globales" method="post" action="options.php">
        <?php settings_fields('global-var-settings'); ?>
        <?php do_settings_sections('global-var-settings'); ?>



        <table class="form-table">
        <tr valign="top">
                <th scope="row">Nombre d'avis global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-avis" value="<?php echo esc_attr(get_option('logia-dynamic-tag-avis')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Email global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-email" value="<?php echo esc_attr(get_option('logia-dynamic-tag-email')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Téléphone global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-phone" value="<?php echo esc_attr(get_option('logia-dynamic-tag-phone')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Adresse global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-address" value="<?php echo esc_attr(get_option('logia-dynamic-tag-address')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Facebook global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-facebook" value="<?php echo esc_attr(get_option('logia-dynamic-tag-facebook')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Instagram global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-instagram" value="<?php echo esc_attr(get_option('logia-dynamic-tag-instagram')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">LinkedIn global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-linkedin" value="<?php echo esc_attr(get_option('logia-dynamic-tag-linkedin')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">YouTube global</th>
                <td>
                    <input type="text" name="logia-dynamic-tag-youtube" value="<?php echo esc_attr(get_option('logia-dynamic-tag-youtube')); ?>" />
                </td>
            </tr>

        </table>
        <?php submit_button(); ?>

    </form>


    <h2>Paramètres des cookies</h2>
    <form title="Cookies" method="post" action="options.php">
        <?php settings_fields('ccp-settings-group'); ?>
        <?php do_settings_sections('ccp-settings-group'); ?>

        <table class="form-table">
            <tr valign="top">
                <th scope="row">Activé/Désactivé Plugin</th>
                <td>
                    <input type="checkbox" name="ccp_plugin_enabled" value="1" <?php checked(1, get_option('ccp_plugin_enabled'), true); ?> />
                    <label for="ccp_plugin_enabled">Enable Cookies Consent</label>
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">Logo</th>
                <td>
                    <input id="ccp_logo" type="text" name="ccp_logo" value="<?php echo esc_attr(get_option('ccp_logo')); ?>" />
                    <input id="upload_logo_button" type="button" class="button" value="Upload Logo" />
                    <script>
                        jQuery(document).ready(function($) {
                            $('#upload_logo_button').click(function(e) {
                                e.preventDefault();
                                var custom_uploader = wp.media({
                                    title: 'Select Logo',
                                    button: {
                                        text: 'Set as Logo'
                                    },
                                    multiple: false
                                }).on('select', function() {
                                    var attachment = custom_uploader.state().get('selection').first().toJSON();
                                    $('#ccp_logo').val(attachment.url);
                                }).open();
                            });
                        });
                    </script>
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">Couleur principale</th>
                <td>
                    <input type="text" class="ccp-color-picker" name="ccp_main_color" value="<?php echo esc_attr(get_option('ccp_main_color')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Couleur de hover</th>
                <td>
                    <input type="text" class="ccp-color-picker" name="ccp_main_color_hover" value="<?php echo esc_attr(get_option('ccp_main_color_hover')); ?>" />
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Type de cookies</th>
                <td>
                    <select name="ccp_layout">
                        <option value="box" <?php selected(get_option('ccp_layout'), 'box'); ?>>Box</option>
                        <option value="cloud" <?php selected(get_option('ccp_layout'), 'cloud'); ?>>Cloud</option>
                        <option value="bar" <?php selected(get_option('ccp_layout'), 'bar'); ?>>Bar</option>
                    </select>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Positionnement</th>
                <td>
                    <select name="ccp_position">
                        <option value="bottom left" <?php selected(get_option('ccp_position'), 'bottom left'); ?>>Bottom Left</option>
                        <option value="bottom center" <?php selected(get_option('ccp_position'), 'bottom center'); ?>>Bottom Center</option>
                        <option value="bottom right" <?php selected(get_option('ccp_position'), 'bottom right'); ?>>Bottom Right</option>
                        <option value="middle left" <?php selected(get_option('ccp_position'), 'middle left'); ?>>Middle Left</option>
                        <option value="middle center" <?php selected(get_option('ccp_position'), 'middle center'); ?>>Middle Center</option>
                        <option value="middle right" <?php selected(get_option('ccp_position'), 'middle right'); ?>>Middle Right</option>
                        <option value="top left" <?php selected(get_option('ccp_position'), 'top left'); ?>>Top Left</option>
                        <option value="top center" <?php selected(get_option('ccp_position'), 'top center'); ?>>Top Center</option>
                        <option value="top right" <?php selected(get_option('ccp_position'), 'top right'); ?>>Top Right</option>
                    </select>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Animation</th>
                <td>
                    <select name="ccp_transition">
                        <option value="zoom" <?php selected(get_option('ccp_transition'), 'zoom'); ?>>Zoom</option>
                        <option value="slide" <?php selected(get_option('ccp_transition'), 'slide'); ?>>Slide</option>
                    </select>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Inversé les buttons</th>
                <td>
                    <input type="checkbox" name="ccp_swap_buttons" value="1" <?php checked(get_option('ccp_swap_buttons'), 1); ?>>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row">Mode sombre</th>
                <td>
                    <input type="checkbox" name="ccp_dark_button" value="1" <?php checked(get_option('ccp_dark_button'), 1); ?>>
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">Titre</th>
                <td>
                    <input type="text" name="ccp_title" value="<?php echo esc_attr(get_option('ccp_title')); ?>" />
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">Description</th>
                <td>
                    <textarea name="ccp_description" rows="5" cols="50"><?php echo esc_textarea(get_option('ccp_description')); ?></textarea>
                </td>
            </tr>
        </table>


        <?php submit_button(); ?>
    </form>


    <h2>Paramètres de la scrollbar</h2>
    <form title="ScrollBar" method="post" action="options.php">
        <?php settings_fields('scrollbar-settings-group'); ?>
        <?php do_settings_sections('scrollbar-settings-group'); ?>
        <div class="scrollBarDiv">
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Couleur de la poignée de la scrollBar</th>
                    <td>
                        <input type="text" class="scrol-color-picker" name="scrollbar-thumb-color" value="<?php echo esc_attr(get_option('scrollbar-thumb-color')); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Couleur du hover de la poignée de la scrollBar</th>
                    <td>
                        <input type="text" class="scrol-color-picker" name="scrollbar-thumb-color-hover" value="<?php echo esc_attr(get_option('scrollbar-thumb-color-hover')); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Couleur du fond de la scrollBar</th>
                    <td>
                        <input type="text" class="scrol-color-picker" name="scrollbar-track-color" value="<?php echo esc_attr(get_option('scrollbar-track-color')); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Style de la scrollBar <img style="width:30px; height:30px;" src="https://upload.wikimedia.org/wikipedia/commons/a/a0/Firefox_logo%2C_2019.svg"></th>
                    <td>
                        <select name="scrollbar-width-style">
                            <option value="auto" <?php selected(get_option('scrollbar-width-style'), 'auto'); ?>>Auto</option>
                            <option value="thin" <?php selected(get_option('scrollbar-width-style'), 'thin'); ?>>Fine</option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Largeur de la scrollBar</th>
                    <td>
                        <input type="number" name="scrollbar-width" value="<?php echo esc_attr(get_option('scrollbar-width') ?: 10); ?>" />

                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Arrondi de la scrollBar</th>
                    <td>
                        <input type="number" name="scrollbar-border-radius" value="<?php echo esc_attr(get_option('scrollbar-border-radius') ?: 0); ?>" />
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Style de la bordure de la scrollBar <img style="width:15px; height:15px;" src="https://upload.wikimedia.org/wikipedia/commons/a/a0/Firefox_logo%2C_2019.svg"></th>
                    <td>
                        <select name="scrollbar-border-style">
                            <option <?php selected(get_option('scrollbar-border-style'), 'none'); ?> value="none">None</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'dotted'); ?> value="dotted">Dotted</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'dashed'); ?> value="dashed">Dashed</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'solid'); ?> value="solid">Solid</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'double'); ?> value="double">Double</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'groove'); ?> value="groove">Groove</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'ridge'); ?> value="ridge">Ridge</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'inset'); ?> value="inset">Inset</option>
                            <option <?php selected(get_option('scrollbar-border-style'), 'outset'); ?> value="outset">Outset</option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Largeur du contour de la scrollBar</th>
                    <td>
                        <input type="number" name="scrollbar-border-width" value="<?php echo esc_attr(get_option('scrollbar-border-width') ?: 0); ?>" />
                    </td>
                </tr>

                <tr valign="top">
                    <th scope="row">Couleur du contour de la scrollBar <img style="width:15px; height:15px;" src="https://upload.wikimedia.org/wikipedia/commons/e/e1/Google_Chrome_icon_%28February_2022%29.svg"></th>
                    <td>
                        <input type="text" class="scrol-color-picker" name="scrollbar-border-color" value="<?php echo esc_attr(get_option('scrollbar-border-color')); ?>" />
                    </td>
                </tr>
            </table>
            <div class="scrollbarContainer">
                <h2>Scroll me...</h2>

                <p>Sometimes, the content of an element is bigger than the element itself, but you still want people to be able to see all of it, so you set the css of the element to overflow: scroll to add a scrollbar to it.</p>
                <p>Then, to your horror, an ugly grey scrollbar is added to your page, which totally ruins the themeing you've worked so hard on, so what can you do?</p>
                <p>Well... It turns out that many modern browsers have pseudo element selectors that you can use to style the scrollbars on your page, and seeing as it can be a bit of a pain reloading a page again and again to see what each one does, I figured why not make a simple little pen to let you style scrollbars live in the browser, and then copy the code to your own website once you're done.</p>
                <img class="pug" src="https://images.pexels.com/photos/1851164/pexels-photo-1851164.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260" alt="A cute pug">
                <p class="bigger">Hey there, don't mind me. I'm just chilling down here.</p>
            </div>
        </div>
        <?php submit_button(); ?>
    </form>
</div>

<h2>Paramètres du caret et de la séléction</h2>
<form title="Caret et séléction" method="post" action="options.php">
    <?php settings_fields('caret-settings-group'); ?>
    <?php do_settings_sections('caret-settings-group'); ?>
    <table class="form-table">
        <tr valign="top">
            <th scope="row">Couleur du caret</th>
            <td>
                <input type="text" class="caret-color-picker" name="caret-color" value="<?php echo esc_attr(get_option('caret-color')); ?>" />
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Couleur du texte de la selection</th>
            <td>
                <input type="text" class="caret-color-picker" name="selection-text-color" value="<?php echo esc_attr(get_option('selection-text-color')); ?>" />
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Couleur du fond de la selection</th>
            <td>
                <input type="text" class="caret-color-picker" name="selection-background-color" value="<?php echo esc_attr(get_option('selection-background-color')); ?>" />
            </td>
        </tr>
    </table>
    <?php submit_button(); ?>
</form>


<h2>Paramètres du Thème</h2>
<form title="Paramètre du Thème" method="post" action="options.php">
    <?php settings_fields('theme-settings-group'); ?>
    <?php do_settings_sections('theme-settings-group'); ?>
    <table class="form-table">
        <tr valign="top">
            <th scope="row">Couleur du thème</th>
            <td>
                <input type="text" class="theme-color-picker" name="theme-color" value="<?php echo esc_attr(get_option('theme-color')); ?>" />
            </td>
        </tr>

    </table>
    <?php submit_button(); ?>
</form>

<h2>Paramètres du sitemap</h2>
<form title="Paramètre du sitemap" method="post" action="options.php">
    <?php settings_fields('sitemap-settings'); ?>
    <?php do_settings_sections('sitemap-settings'); ?>
    <table class="form-table">
        <tr>
            <th scope="row">
                <label for="sitemap_menu">Select Menu for Sitemap</label>
            </th>
            <td>
                <?php
                $menus = get_terms('nav_menu', array('hide_empty' => false));
                $selected_menu = get_option('sitemap_menu');
                ?>
                <select name="sitemap_menu" id="sitemap_menu">
                    <?php foreach ($menus as $menu) : ?>
                        <option value="<?php echo $menu->term_id; ?>" <?php selected($selected_menu, $menu->term_id); ?>><?php echo $menu->name; ?></option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

    </table>
    <?php submit_button(); ?>
</form>

<?php include plugin_dir_path(__FILE__) . 'contextMenu/contextMenuSettings/main.php'; ?>

<style id="scrollBarStyle">

</style>
<style id="caretSelectionStyle">

</style>
<style>
    
.template {
  position: relative;
  width: 50%;
padding: 1.5rem;
box-shadow: rgba(0, 0, 0, 0.05) 0px 6px 24px 0px, rgba(0, 0, 0, 0.08) 0px 0px 0px 1px;
  border-width: 1px;
border-radius: .5rem;
}
.template img {
  width: 100%;
}
.templates {
  gap:10px;
  margin-top:10px;
  margin-bottom: 40px;
  display: flex;
}
.template .badge {
  position: absolute;
  right:15px;
  top:15px;
  background-color:white;
  text-transform: uppercase;
  padding:10px;
  box-shadow: rgba(0, 0, 0, 0.05) 0px 6px 24px 0px, rgba(0, 0, 0, 0.08) 0px 0px 0px 1px;
}
    .scrollbarContainer {
        overflow: scroll;
        min-width: 500px;
        max-width: 500px;
        min-height: 500px;
        max-height: 500px;
        background-color: white;
        padding: 40px;
    }

    .scrollBarDiv {
        display: flex;
    }

    form {
        padding: 20px;
        background-color: #f2f2f438;
        border-radius: 10px;
        box-shadow: rgba(0, 0, 0, 0.02) 0px 1px 3px 0px, rgba(27, 31, 35, 0.15) 0px 0px 0px 1px;
    }

    form p.submit {

        margin-bottom: 0px;
        padding-bottom: 0px
    }
</style>
<script>
    jQuery(document).ready(function($) {
        jQuery('.theme-color-picker').wpColorPicker();
        jQuery('.ccp-color-picker').wpColorPicker();
        jQuery('context_menu_text_color').wpColorPicker();
        jQuery('context_menu_background_color').wpColorPicker();
        jQuery('context_menu_hover_color').wpColorPicker();
        jQuery('.caret-color-picker').wpColorPicker({
            change: function(event, ui) {
                updateCaretSelectionStyle()
            }
        });
        jQuery('.scrol-color-picker').wpColorPicker({
            change: function(event, ui) {
                updateStyleScrollbar()
            }
        });



        const scrollbarThumbColor = document.querySelector('[name="scrollbar-thumb-color"]')
        const scrollbarThumbColorHover = document.querySelector('[name="scrollbar-thumb-color-hover"]')
        const scrollbarTrackColor = document.querySelector('[name="scrollbar-track-color"]');
        const scrollbarWidthStyle = document.querySelector('[name="scrollbar-width-style"]');
        const scrollbarWidth = document.querySelector('[name="scrollbar-width"]');
        const scrollbarBorderRadius = document.querySelector('[name="scrollbar-border-radius"]');
        const scrollbarBorderWidth = document.querySelector('[name="scrollbar-border-width"]');
        const scrollbarBorderStyle = document.querySelector('[name="scrollbar-border-style"]');
        const scrollbarBorderColor = document.querySelector('[name="scrollbar-border-color"]');

        // scrollbarThumbColor.addEventListener("change", updateStyleScrollbar);
        //scrollbarTrackColor.addEventListener("change", updateStyleScrollbar);
        scrollbarWidthStyle.addEventListener("change", updateStyleScrollbar);
        scrollbarWidth.addEventListener("change", updateStyleScrollbar);
        scrollbarBorderRadius.addEventListener("change", updateStyleScrollbar);
        scrollbarBorderWidth.addEventListener("change", updateStyleScrollbar);
        scrollbarBorderStyle.addEventListener("change", updateStyleScrollbar);
        // scrollbarBorderColor.addEventListener("change", updateStyleScrollbar);






        const caretColor = document.querySelector('[name="caret-color"]');
        const selectedTextColor = document.querySelector('[name="selection-text-color"]');
        const selectedBackgroundColor = document.querySelector('[name="selection-background-color"]');



        function updateCaretSelectionStyle() {
            var styleBlock = document.querySelector("#caretSelectionStyle");
            styleBlock.innerHTML = `
                ::selection {
                    color:${selectedTextColor.value};
                    background-color:${selectedBackgroundColor.value};
                }
                input, textarea {
                    caret-color:${caretColor.value};
                }

                input:focus::placeholder {
                    color:transparent;
                }

        `;

        }
        updateCaretSelectionStyle();

        function updateStyleScrollbar() {
            var styleBlock = document.querySelector("#scrollBarStyle");

            styleBlock.innerHTML = `
                /* ===== Scrollbar CSS ===== */
                /* Firefox */
                @supports (-moz-appearance:none) {
                .scrollbarContainer {
                    scrollbar-width: ${scrollbarWidthStyle.value};
                    scrollbar-color: ${scrollbarThumbColor.value} ${scrollbarTrackColor.value};
                }
            }
                /* Chrome, Edge, and Safari */
                .scrollbarContainer::-webkit-scrollbar {
                    width: ${scrollbarWidth.value}px;
                }

                .scrollbarContainer::-webkit-scrollbar-track {
                    background: ${scrollbarTrackColor.value};
                }

                .scrollbarContainer::-webkit-scrollbar-thumb {
                    background-color: ${scrollbarThumbColor.value};
                    border-radius: ${scrollbarBorderRadius.value}px;
                    border: ${scrollbarBorderWidth.value}px ${scrollbarBorderStyle.value} ${scrollbarBorderColor.value};
                }*

                .scrollbarContainer::-webkit-scrollbar-thumb:hover {
                    background-color: ${scrollbarThumbColorHover.value};
                 
                }
        
        `;

        }
        updateStyleScrollbar()


        jQuery('form[action="options.php"]').submit(function(event) {
            event.preventDefault();

            var formData = jQuery(this).serialize();
            var title = jQuery(this).attr('title');
            jQuery.ajax({
                type: 'POST',
                url: jQuery(this).attr('action'), // Posting to options.php
                data: formData,
                success: function(response) {
                    alert(title + ' sauvegardé !');
                },
                error: function() {
                    alert(title + ' Bug de sauvegarde');
                }
            });
        });


    });



    function updateStylesFromCSSVars() {
        const rootStyles = getComputedStyle(document.documentElement);

        const properties = {
            "ccp_main_color": '--uip-color-primary',
            "scrollbar-thumb-color": '--uip-color-primary',
            "scrollbar-thumb-color-hover": '--uip-button-primary-hover-bg',
            "caret-color": '--uip-color-primary',
            "selection-text-color": '--uip-button-primary-text-color',
            "selection-background-color": '--uip-color-primary',
            "ccp_main_color_hover": '--uip-button-primary-hover-bg',
            "theme-color": '--uip-color-primary',
            "scrollbar-track-color": '--uip-color-default'
        };

        for (const property in properties) {
            const element = document.querySelector(`[name='${property}']`);
            const value = rootStyles.getPropertyValue(properties[property]).trim();

            if (element) {
                element.value = value;

                // Trigger the input event
                const event = new Event('change', {
                    'bubbles': true,
                    'cancelable': true
                });
                element.dispatchEvent(event);
            }
        }
    }

    document.getElementById('importUIPress').addEventListener('click', updateStylesFromCSSVars);
</script>