{{ ucfunc("put_docready_start") }}

	 var objWidget = jQuery('#{{uc_id}}');

      {% if grid_type == "masonry" %}
      
        var UEMasonryGrid = new MiniMasonry({
            container: '#{{uc_id}}',
            gutter: {{gutter}},
            baseWidth: {{basewidth}},
            minify: {{minify}},
            surroundingGutter: {{surroundinggutter}},
            ultimateGutter:	{{ultimategutter}}, 
            direction: "{{direction}}"

        });

       function initializeMasonryLayout() {
        UEMasonryGrid.layout();
       }
       
       initializeMasonryLayout();

       window.onload = function () {
        initializeMasonryLayout();
       };
       
       
        var objWrapper = jQuery("#{{uc_id}}");

        objWrapper.on("uc_ajax_refreshed",function(){
          initializeMasonryLayout();
          setTimeout(initializeMasonryLayout, 2000)
        });
       
      {% endif %}	
      
      /**
      *	find style tag inside first item and prepend it to widget
      */
      function findStyleAndPrepend(){       
        var dataTemplateId = objWidget.data('template-id');
        
        var objStyle = objWidget.find('style#elementor-post-'+dataTemplateId);
        
        if(!objStyle.length)
        return(false);
        
        objStyle.insertBefore(objWidget);
        
      }
       
      /**
       * is element in viewport
       */
      function isElementInViewport(objElement) {

            var elementTop = objElement.offset().top;
            var elementBottom = elementTop + objElement.outerHeight();

            var viewportTop = jQuery(window).scrollTop();
            var viewportBottom = viewportTop + jQuery(window).height();

            return (elementBottom > viewportTop && elementTop < viewportBottom);
      }
       
      /**
      * reveal Elementor Animation
      */
      function revealElementorAnimation(objChildSection, animation){
        objChildSection.removeClass(animation + ' animated elementor-invisible');
          
        // Trigger reflow to restart the animation
        void objChildSection[0].offsetWidth;

        // Add the animation class
        objChildSection.addClass('animated '+animation);
      }
       
      /**
      * init Elementor animatin foe section element
      */
      function initElementorAnimation(){
        var objItems = objWidget.find(".ue-grid-item");
        
        if(!objItems || objItems.length == 0)
        return(false);
                
        objItems.each(function(){
          var objItem = jQuery(this);
          var objChildSection = objItem.find('.elementor > *'); //supports only first element after .elementor selector
          
          if(!objChildSection || objChildSection.length == 0)
          return(true);
          
          var dataSettings = objChildSection.attr("data-settings");
          
          if(!dataSettings)
          return(true);
          
          dataSettings = JSON.parse(dataSettings);
          
          var animation = dataSettings.animation;
          
          if(!animation)
          return(true);  
          
          if(objChildSection.hasClass("animated") == true)
          return(true);
          
          if(isElementInViewport(objChildSection) == true){
          	revealElementorAnimation(objChildSection, animation);
          }
          
        });
      }

      objWidget.on("uc_ajax_refreshed",function(){
         //init support for elementor animations
        initElementorAnimation();
      });
       
      jQuery(window).on("scroll", initElementorAnimation);
       
      findStyleAndPrepend();
       
      {% if remote_parent.attributes is not empty %}

      var objRemoteOptions = {
          class_items:"ue-grid-item",
          class_active:"ue-active-item",
          add_set_active_code:true
      };

      {{ucfunc("put_remote_parent_js","objWidget","objRemoteOptions")}}  

  {% endif %}

{{ ucfunc("put_docready_end") }}