/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/assets/js/rename.js":
/*!*********************************!*\
  !*** ./src/assets/js/rename.js ***!
  \*********************************/
/***/ (() => {

jQuery(document).ready(function () {
  // STEP: Get all post IDs from #the-list
  var postIds = jQuery('#the-list tr').map(function () {
    return this.id.replace('post-', '');
  }).get();

  // STEP: Get original filenames of post IDs
  jQuery.ajax({
    url: ajaxurl,
    type: 'POST',
    data: {
      action: 'happyfiles_get_original_filenames',
      postIds: postIds,
      nonce: HappyFiles.nonce
    },
    success: function success(response) {
      var originalFilenamesById = response.data;
      window.HappyFiles.originalFilenamesById = originalFilenamesById;
      HappyFilesCreateRenameHtml();
    }
  });

  // STEP: Setup rename event listeners
  window.addEventListener('keydown', function (e) {
    // Enter key press: Rename file
    if (e.key === 'Enter') {
      if (e.target.closest('.hapypfiles-rename-input-wrapper')) {
        e.preventDefault();
        var postId = e.target.closest('tr').getAttribute('id').replace('post-', '');
        HappyFilesRenameFile(postId, e.target.value);
      }
    }

    // Tab key pressed: Focus on previous/next file rename input
    // NOTE: Maybe disable by default (a11y) & provide setting to manually enabled
    else if (e.key === 'Tab') {
      var currentRow = e.target.closest('tr');
      if (!currentRow || e.target.nodeName !== 'INPUT' || !e.target.closest('.hapypfiles-rename-input-wrapper')) {
        return;
      }
      var goToRow = e.shiftKey ? currentRow.previousElementSibling : currentRow.nextElementSibling;
      if (goToRow) {
        e.preventDefault();
        var goToInput = goToRow.querySelector('.hapypfiles-rename-input-wrapper input[type="text"]');
        if (goToInput) {
          goToInput.focus();
        }
      }
    }
  });
});

/**
 * Create file rename HTML & listeners
 *
 * @since 1.8.3
 */
HappyFilesCreateRenameHtml = function HappyFilesCreateRenameHtml() {
  // STEP: Add rename HTML & listeners to every row
  var filenameNodes = jQuery('.wp-list-table.media .column-title .filename');
  filenameNodes.each(function (index, filenameNode) {
    var _window$HappyFiles$or, _window$HappyFiles$or2;
    var postId = filenameNode.closest('tr').getAttribute('id').replace('post-', '');
    var originalFilename = (_window$HappyFiles$or = window.HappyFiles.originalFilenamesById) === null || _window$HappyFiles$or === void 0 ? void 0 : _window$HappyFiles$or[postId];

    // STEP: Add rename wrapper
    var renameWrapper = document.createElement('div');
    renameWrapper.setAttribute('class', 'happyfiles-rename-wrapper');
    filenameNode.insertAdjacentElement('beforebegin', renameWrapper);

    // Add .renamed class to show undo button
    if ((_window$HappyFiles$or2 = window.HappyFiles.originalFilenamesById) !== null && _window$HappyFiles$or2 !== void 0 && _window$HappyFiles$or2[postId]) {
      renameWrapper.classList.add('renamed');
    }

    // STEP: Add input wrapper
    var renameInputWrapper = document.createElement('div');
    renameInputWrapper.classList.add('hapypfiles-rename-input-wrapper');
    renameWrapper.append(renameInputWrapper);

    // STEP: Add rename input to title column
    var filename = filenameNode.lastChild.textContent.trim();
    var renameInput = document.createElement('input');
    renameInput.setAttribute('type', 'text');
    renameInput.setAttribute('autocomplete', 'off');
    renameInput.setAttribute('spellcheck', 'false');
    renameInput.setAttribute('value', filename);
    renameInputWrapper.append(renameInput);

    // Show rename actions when input value changes
    renameInput.addEventListener('input', function () {
      renameWrapper.classList.add('renaming');
    });

    // STEP: Add rename by title button
    var renameByTitleButton = document.createElement('button');
    renameByTitleButton.classList.add('rename-by-title');
    renameByTitleButton.classList.add('button');
    renameByTitleButton.title = 'Rename by title';
    renameInputWrapper.append(renameByTitleButton);

    // Add rename by title icon
    var renameByTitleIcon = document.createElement('i');
    renameByTitleIcon.classList.add('dashicons');
    renameByTitleIcon.classList.add('dashicons-edit');
    renameByTitleButton.prepend(renameByTitleIcon);

    // Add rename by title button click listener
    renameByTitleButton.addEventListener('click', function (e) {
      e.preventDefault();
      var title = renameWrapper.previousElementSibling.innerText;

      // Convert to lowercase
      title = title.toLowerCase();

      // Replace spaces with hyphens
      title = title.replace(/\s/g, '-');

      // Remove special characters
      title = title.replace(/[^\w\-]+/g, '');

      // Remove leading or trailing hyphens
      title = title.replace(/^-+|-+$/g, '');
      var extension = filename.split('.').pop();
      var renameTitleConfirmed = confirm("Please confirm renaming this file based on its title to: ".concat(title, ".").concat(extension));

      // Rename file by title
      if (renameTitleConfirmed) {
        HappyFilesRenameFile(postId, title);
      }
    });

    // STEP: Add undo button
    var undoButton = document.createElement('button');
    undoButton.classList.add('undo');
    undoButton.classList.add('button');
    undoButton.title = 'Undo rename';
    renameInputWrapper.append(undoButton);
    var undoIcon = document.createElement('i');
    undoIcon.classList.add('dashicons');
    undoIcon.classList.add('dashicons-undo');
    undoButton.prepend(undoIcon);

    // Add undo button click listener
    undoButton.addEventListener('click', function (e) {
      e.preventDefault();
      var undoConfirmed = confirm("Please confirm undoing the rename to the original filename: ".concat(originalFilename));
      if (undoConfirmed) {
        HappyFilesRenameFile(postId, originalFilename, true);
      }
    });

    // STEP: Add action wrapper & rename/cancel buttons
    var renameActions = document.createElement('div');
    renameActions.classList.add('actions');
    renameWrapper.append(renameActions);

    // Add rename button
    var renameButton = document.createElement('button');
    renameButton.classList.add('submit');
    renameButton.classList.add('button');
    renameButton.classList.add('button-primary');
    renameButton.innerText = 'Rename';
    renameActions.append(renameButton);

    // Rename button clicked: Rename file
    renameButton.addEventListener('click', function (e) {
      e.preventDefault();
      var postId = e.target.closest('tr').getAttribute('id').replace('post-', '');
      var filename = renameInput.value;
      HappyFilesRenameFile(postId, filename);
    });

    // Add cancel button
    var cancelButton = document.createElement('button');
    cancelButton.classList.add('cancel');
    cancelButton.classList.add('button');
    cancelButton.innerText = 'Cancel';
    renameActions.append(cancelButton);
    cancelButton.addEventListener('click', function (e) {
      e.preventDefault();
      renameWrapper.classList.remove('renaming');

      // Reset input value to original filename
      renameInput.value = filename;
    });
  });
};
HappyFilesRenameFile = function HappyFilesRenameFile() {
  var postId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
  var filename = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var undo = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (!filename) {
    return;
  }
  jQuery.ajax({
    method: 'POST',
    url: HappyFiles.ajaxUrl,
    data: {
      action: 'happyfiles_rename_file_manually',
      postId: postId,
      filename: filename,
      nonce: HappyFiles.nonce,
      undo: undo
    },
    success: function success(res) {
      var _res$data, _res$data2, _res$data3;
      // JS check if URL contains debug URL param
      if (HappyFiles.debug) {
        console.info('happyfiles_rename_file_manually', res.data);
      }
      var renameWrapper = document.querySelector("#post-".concat(postId, " .happyfiles-rename-wrapper"));
      renameWrapper.classList.remove('renaming');
      if ((_res$data = res.data) !== null && _res$data !== void 0 && _res$data.error) {
        alert(res.data.error);
      }

      // File rename undo success: Hide rename button
      else if (undo) {
        renameWrapper.classList.remove('renamed');
      }
      var filename = ((_res$data2 = res.data) === null || _res$data2 === void 0 ? void 0 : _res$data2.filename) || ((_res$data3 = res.data) === null || _res$data3 === void 0 ? void 0 : _res$data3.new_filename);

      // Set input value to filename
      if (filename) {
        var _res$data4;
        var extension = (_res$data4 = res.data) === null || _res$data4 === void 0 ? void 0 : _res$data4.extension;

        // Append extension to filename
        if (extension && !filename.endsWith(".".concat(extension))) {
          filename = "".concat(filename, ".").concat(extension);
        }
        var renameInput = renameWrapper.querySelector('input');
        if (renameInput) {
          renameInput.value = filename;
        }
      }
    }
  });
};

/***/ }),

/***/ "./src/assets/scss/happyfiles.scss":
/*!*****************************************!*\
  !*** ./src/assets/scss/happyfiles.scss ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/assets/scss/settings.scss":
/*!***************************************!*\
  !*** ./src/assets/scss/settings.scss ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/assets/scss/gallery.scss":
/*!**************************************!*\
  !*** ./src/assets/scss/gallery.scss ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./src/assets/scss/lightgallery/lightgallery.scss":
/*!********************************************************!*\
  !*** ./src/assets/scss/lightgallery/lightgallery.scss ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"/js/rename.min": 0,
/******/ 			"libs/lightgallery/css/lightgallery.min": 0,
/******/ 			"css/gallery.min": 0,
/******/ 			"css/settings.min": 0,
/******/ 			"css/happyfiles.min": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = self["webpackChunkhappyfiles"] = self["webpackChunkhappyfiles"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	__webpack_require__.O(undefined, ["libs/lightgallery/css/lightgallery.min","css/gallery.min","css/settings.min","css/happyfiles.min"], () => (__webpack_require__("./src/assets/js/rename.js")))
/******/ 	__webpack_require__.O(undefined, ["libs/lightgallery/css/lightgallery.min","css/gallery.min","css/settings.min","css/happyfiles.min"], () => (__webpack_require__("./src/assets/scss/happyfiles.scss")))
/******/ 	__webpack_require__.O(undefined, ["libs/lightgallery/css/lightgallery.min","css/gallery.min","css/settings.min","css/happyfiles.min"], () => (__webpack_require__("./src/assets/scss/settings.scss")))
/******/ 	__webpack_require__.O(undefined, ["libs/lightgallery/css/lightgallery.min","css/gallery.min","css/settings.min","css/happyfiles.min"], () => (__webpack_require__("./src/assets/scss/gallery.scss")))
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["libs/lightgallery/css/lightgallery.min","css/gallery.min","css/settings.min","css/happyfiles.min"], () => (__webpack_require__("./src/assets/scss/lightgallery/lightgallery.scss")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;